/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.refactoring;

import com.mastfrog.function.state.Bool;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import com.telenav.cactus.maven.model.ArtifactId;
import com.telenav.cactus.maven.model.GroupId;
import com.telenav.cactus.maven.model.MavenArtifactCoordinates;
import com.telenav.cactus.maven.model.MavenIdentified;
import com.telenav.cactus.maven.model.MavenVersioned;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.PomVersion;
import com.telenav.cactus.maven.model.VersionChange;
import com.telenav.cactus.maven.model.VersionChangeMagnitude;
import com.telenav.cactus.maven.model.VersionFlavorChange;
import com.telenav.cactus.maven.model.internal.PomFile;
import com.telenav.cactus.maven.model.published.PublishChecker;
import com.telenav.cactus.maven.model.resolver.Poms;
import com.telenav.cactus.maven.refactoring.PomCategorizer;
import com.telenav.cactus.maven.refactoring.PropertyChange;
import com.telenav.cactus.maven.refactoring.SuperpomBumpPolicy;
import com.telenav.cactus.maven.refactoring.VersionChangeUpdatesCollector;
import com.telenav.cactus.maven.refactoring.VersionIndicatingProperties;
import com.telenav.cactus.maven.refactoring.VersionMismatchPolicy;
import com.telenav.cactus.maven.refactoring.VersionMismatchPolicyOutcome;
import com.telenav.cactus.maven.refactoring.VersionUpdateFilter;
import com.telenav.cactus.maven.refactoring.VersionUpdateFinder;
import com.telenav.cactus.maven.xml.AbstractXMLUpdater;
import com.telenav.cactus.maven.xml.XMLElementRemoval;
import com.telenav.cactus.maven.xml.XMLFile;
import com.telenav.cactus.maven.xml.XMLReplacer;
import com.telenav.cactus.maven.xml.XMLTextContentReplacement;
import com.telenav.cactus.maven.xml.XMLVersionElementAdder;
import com.telenav.cactus.scope.ProjectFamily;
import com.telenav.cactus.util.SectionedMessage;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.w3c.dom.Document;

public class VersionReplacementFinder {
    private final PomCategorizer categories;
    private final VersionIndicatingProperties potentialPropertyChanges;
    private final Map<ProjectFamily, VersionChange> familyVersionChanges = new HashMap<ProjectFamily, VersionChange>();
    private final Map<Pom, VersionChange> pomVersionChanges = new HashMap<Pom, VersionChange>();
    private final Map<Pom, VersionChange> parentVersionChanges = new HashMap<Pom, VersionChange>();
    private final Map<Pom, Set<PropertyChange<?, PomVersion>>> propertyChanges = new HashMap();
    private final Set<Pom> removeExplicitVersionFrom = new HashSet<Pom>();
    private final Set<Pom> versionMismatches = new HashSet<Pom>();
    private SuperpomBumpPolicy superpomBumpPolicy = SuperpomBumpPolicy.BUMP_WITHOUT_CHANGING_FLAVOR;
    private VersionMismatchPolicy versionMismatchPolicy = VersionMismatchPolicyOutcome.ABORT;
    private boolean pretend;
    private VersionUpdateFilter filter;
    private boolean needResolve = true;
    private boolean bumpAlreadyPublishedPoms;
    private PublishChecker publishChecker = new PublishChecker();

    public VersionReplacementFinder(Poms poms) {
        this.categories = new PomCategorizer(poms);
        this.potentialPropertyChanges = VersionIndicatingProperties.create(this.categories);
    }

    public VersionReplacementFinder withPublishChecker(PublishChecker checker) {
        this.publishChecker = (PublishChecker)Checks.notNull((String)"checker", (Object)checker);
        return this;
    }

    public VersionReplacementFinder withSuperpomBumpPolicy(SuperpomBumpPolicy policy) {
        this.superpomBumpPolicy = (SuperpomBumpPolicy)((Object)Checks.notNull((String)"policy", (Object)((Object)policy)));
        return this;
    }

    public VersionReplacementFinder withVersionMismatchPolicy(VersionMismatchPolicy policy) {
        this.versionMismatchPolicy = (VersionMismatchPolicy)Checks.notNull((String)"policy", (Object)policy);
        return this;
    }

    public VersionReplacementFinder pretend(boolean pretendMode) {
        this.pretend = pretendMode;
        return this;
    }

    public VersionReplacementFinder withFilter(VersionUpdateFilter filter) {
        if (!this.needResolve) {
            throw new IllegalStateException("Cannot set filter at this point");
        }
        this.filter = filter;
        this.needResolve = true;
        return this;
    }

    public VersionReplacementFinder withSinglePomChange(ArtifactId artifactId, PomVersion newVersion) {
        this.needResolve = true;
        return (VersionReplacementFinder)this.categories.poms().get(artifactId).map(pom -> this.withSinglePomChange(pom, newVersion)).orElse((Object)this);
    }

    public VersionReplacementFinder bumpUnpublishedPoms() {
        this.bumpAlreadyPublishedPoms = true;
        return this;
    }

    public Optional<VersionChange> versionChangeFor(Pom pom) {
        return Optional.ofNullable(this.pomVersionChanges.get(pom));
    }

    public VersionReplacementFinder withSinglePomChange(ArtifactId artifactId, GroupId group, PomVersion newVersion) {
        this.needResolve = true;
        return (VersionReplacementFinder)this.categories.poms().get(group, artifactId).map(pom -> this.withSinglePomChange(pom, newVersion)).orElse((Object)this);
    }

    public <P extends MavenIdentified & MavenVersioned> VersionReplacementFinder withSinglePomChange(P what, PomVersion newVersion) {
        this.needResolve = true;
        Consumer<Pom> c = pom -> {
            if (!pom.version().equals((Object)newVersion)) {
                this.pomVersionChanges.put((Pom)pom, new VersionChange(pom.version(), newVersion));
            }
        };
        if (what instanceof Pom) {
            c.accept((Pom)what);
        } else {
            this.categories.poms().get(what).toOptional().ifPresent(c);
        }
        return this;
    }

    public VersionReplacementFinder withFamilyVersionChange(ProjectFamily family, PomVersion old, PomVersion nue) {
        this.needResolve = true;
        VersionChange vc = new VersionChange(old, nue);
        this.familyVersionChanges.put(family, vc);
        return this;
    }

    private void resolveVersionMismatchesAndFinalizeUpdateSet() {
        if (!this.needResolve) {
            return;
        }
        Set<Pom> conflicted = this.collectConflictPoms();
        VersionUpdateFinder finder = new VersionUpdateFinder(this.changeCollector(), this.categories, this.potentialPropertyChanges, this.familyVersionChanges, this.superpomBumpPolicy, this.versionMismatchPolicy, this.publishChecker);
        finder.go();
        if (this.bumpAlreadyPublishedPoms && !conflicted.isEmpty()) {
            conflicted.removeAll(this.pomVersionChanges.keySet());
            conflicted.removeAll(this.parentVersionChanges.keySet());
            if (!conflicted.isEmpty()) {
                Bool changes = Bool.create();
                for (Pom p : conflicted) {
                    p.version().updatedWith(VersionChangeMagnitude.DOT, VersionFlavorChange.UNCHANGED).ifPresent(v -> p.version().to(v).ifPresent(vv -> {
                        this.pomVersionChanges.put(p, (VersionChange)vv);
                        changes.set();
                    }));
                }
                if (changes.getAsBoolean()) {
                    finder.go();
                }
            }
        }
        this.needResolve = false;
    }

    private Set<Pom> collectConflictPoms() {
        if (!this.bumpAlreadyPublishedPoms) {
            return Collections.emptySet();
        }
        try {
            HashSet<Pom> result = new HashSet<Pom>();
            for (Pom p : this.categories.allPoms()) {
                switch (this.publishChecker.check((MavenArtifactCoordinates)p)) {
                    case PUBLISHED_DIFFERENT: {
                        result.add(p);
                    }
                }
            }
            return result;
        }
        catch (IOException | InterruptedException | URISyntaxException ex) {
            return (Set)Exceptions.chuck((Throwable)ex);
        }
    }

    private VersionChangeUpdatesCollector changeCollector() {
        return new VersionChangeUpdatesCollector(this.pomVersionChanges, this.parentVersionChanges, this.propertyChanges, this.removeExplicitVersionFrom, this.versionMismatches, this.filter);
    }

    private Set<AbstractXMLUpdater> xmlUpdaters() {
        this.resolveVersionMismatchesAndFinalizeUpdateSet();
        LinkedHashSet<AbstractXMLUpdater> replacers = new LinkedHashSet<AbstractXMLUpdater>();
        this.removeExplicitVersionFrom.forEach(removeVersionFrom -> replacers.add((AbstractXMLUpdater)new XMLElementRemoval((XMLFile)PomFile.of((Pom)removeVersionFrom), "/project/version")));
        this.propertyChanges.forEach((pom, changes) -> changes.forEach(change -> replacers.add((AbstractXMLUpdater)new XMLTextContentReplacement((XMLFile)PomFile.of((Pom)pom), "/project/properties/" + change.propertyName(), ((PomVersion)change.newValue()).text()))));
        this.pomVersionChanges.forEach((pom, versionChange) -> {
            if (pom.hasExplicitVersion()) {
                String query = "/project/version";
                replacers.add((AbstractXMLUpdater)new XMLTextContentReplacement((XMLFile)PomFile.of((Pom)pom), query, versionChange.newVersion().text()));
            } else {
                replacers.add((AbstractXMLUpdater)new XMLVersionElementAdder((XMLFile)PomFile.of((Pom)pom), versionChange.newVersion().text()));
            }
        });
        this.parentVersionChanges.forEach((pom, versionChange) -> {
            String query = "/project/parent/version";
            replacers.add((AbstractXMLUpdater)new XMLTextContentReplacement((XMLFile)PomFile.of((Pom)pom), query, versionChange.newVersion().text()));
        });
        return replacers;
    }

    public Set<Path> go() throws Exception {
        return this.go(System.out::println);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Path> go(Consumer<String> msgs) throws Exception {
        ArrayList<AbstractXMLUpdater> replacers = new ArrayList<AbstractXMLUpdater>(this.xmlUpdaters());
        Collections.sort(replacers);
        try {
            Set set = (Set)AbstractXMLUpdater.openAll(replacers, () -> {
                HashSet<Path> result = new HashSet<Path>();
                HashMap<Path, Document> docForPath = new HashMap<Path, Document>();
                for (AbstractXMLUpdater abstractXMLUpdater : replacers) {
                    Document changed = abstractXMLUpdater.replace();
                    if (changed == null) continue;
                    Document old = (Document)docForPath.get(abstractXMLUpdater.path());
                    if (old != changed && old != null) {
                        throw new IllegalStateException("Context did not hold - " + old + " vs " + changed + " for " + abstractXMLUpdater.path());
                    }
                    msgs.accept(" CHANGE: " + abstractXMLUpdater);
                    docForPath.put(abstractXMLUpdater.path(), changed);
                }
                for (Map.Entry entry : docForPath.entrySet()) {
                    msgs.accept("Rewrite " + entry.getKey() + (this.pretend ? " (pretend)" : ""));
                    if (!this.pretend) {
                        XMLReplacer.writeXML((Document)((Document)entry.getValue()), (Path)((Path)entry.getKey()));
                    }
                    result.add((Path)entry.getKey());
                }
                return result;
            });
            return set;
        }
        finally {
            this.categories.poms().reload();
        }
    }

    public int changeCount() {
        return this.changeCollector().allChangedPoms().size();
    }

    public void collectChanges(SectionedMessage c) {
        if (!this.pomVersionChanges.isEmpty()) {
            try (SectionedMessage.MessageSection versionChanges = c.section("Version Changes");){
                new TreeMap<Pom, VersionChange>(this.pomVersionChanges).forEach((pom, vc) -> versionChanges.bulletPoint((Object)(pom.toArtifactIdentifiers() + ": " + vc)));
            }
        }
        if (this.parentVersionChanges.isEmpty()) {
            try (SectionedMessage.MessageSection parentVersionChangeC = c.section("Parent Version Changes");){
                new TreeMap<Pom, VersionChange>(this.parentVersionChanges).forEach((pom, vc) -> parentVersionChangeC.bulletPoint((Object)(pom.toArtifactIdentifiers() + ": " + vc)));
            }
        }
        if (!this.propertyChanges.isEmpty()) {
            try (SectionedMessage.MessageSection propertyChangeC = c.section("Property Changes");){
                new TreeMap(this.propertyChanges).forEach((pom, changes) -> {
                    propertyChangeC.bulletPoint((Object)pom.toArtifactIdentifiers());
                    changes.forEach(propC -> propertyChangeC.bulletPoint(2, (Object)("*" + propC.propertyName() + "* -\t`" + propC.oldValue() + "` \u27f6 `" + propC.newValue() + "`")));
                });
            }
        }
    }

    public String toString() {
        Set<AbstractXMLUpdater> replacers = this.xmlUpdaters();
        StringBuilder sb = new StringBuilder("Version Replacements:\n");
        sb.append("FAMILIES:\n");
        this.familyVersionChanges.forEach((fam, ver) -> sb.append(" * ").append(fam).append(" -> ").append(ver).append('\n'));
        if (!this.pomVersionChanges.isEmpty()) {
            sb.append("POMS:\n");
            this.pomVersionChanges.forEach((pom, ver) -> sb.append(" * ").append(pom.coordinates().toArtifactIdentifiers()).append(" -> ").append(ver).append('\n'));
        }
        if (!this.parentVersionChanges.isEmpty()) {
            sb.append("PARENT CHANGES:\n");
            this.parentVersionChanges.forEach((pom, ver) -> sb.append(" * ").append(pom.coordinates().toArtifactIdentifiers()).append(" ->-> ").append(ver).append('\n'));
        }
        if (!this.potentialPropertyChanges.isEmpty()) {
            sb.append("PROPERTIES REPRESENTING VERSIONS:\n");
            sb.append(this.potentialPropertyChanges);
        }
        if (!this.propertyChanges.isEmpty()) {
            sb.append("\nPROPERTY CHANGES:\n");
            this.propertyChanges.forEach((pom, change) -> sb.append(" * ").append(change).append('\n'));
        }
        if (!this.removeExplicitVersionFrom.isEmpty()) {
            sb.append("\nREMOVE SUPERFLUOUS VERSIONS FROM:\n");
            this.removeExplicitVersionFrom.forEach(pom -> sb.append(" * ").append(pom.toArtifactIdentifiers()).append(' ').append(pom.path()).append('\n'));
        }
        if (!this.categories.rolesForPom().isEmpty()) {
            sb.append("ROLES:\n");
            this.categories.eachPomAndItsRoles((pom, roles) -> {
                String par = this.categories.parentOf((Pom)pom).map(p -> p.artifactId().toString()).orElse("");
                sb.append(" * ").append(pom.toArtifactIdentifiers()).append(' ').append(roles).append((String)(this.versionMismatches.contains(pom) ? " **VERSION-MISMATCH** " + pom.version() : "")).append(" parent ").append(par).append('\n');
            });
        }
        if (!replacers.isEmpty()) {
            sb.append("\n-------------- REPLACERS ----------------\n");
            replacers.forEach(rep -> sb.append(" * ").append(rep).append("\n"));
        }
        return sb.toString();
    }
}

