/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.refactoring;

import com.telenav.cactus.maven.model.GroupId;
import com.telenav.cactus.maven.model.MavenIdentified;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.PomVersion;
import com.telenav.cactus.maven.model.VersionChange;
import com.telenav.cactus.scope.ProjectFamily;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;

public interface VersionUpdateFilter {
    public static final VersionUpdateFilter DEFAULT = new VersionUpdateFilter(){};

    default public boolean shouldUpdateVersionProperty(Pom in, String propertyName, PomVersion newVersion, String currentValue) {
        return true;
    }

    default public boolean shouldUpdatePomVersion(Pom in, VersionChange change) {
        return true;
    }

    default public boolean shouldUpdateParentVersion(Pom in, Pom parent, VersionChange change) {
        return this.shouldUpdatePomVersion(parent, change);
    }

    public static VersionUpdateFilter withinFamily(ProjectFamily fam) {
        return VersionUpdateFilter.withinFamilies(Collections.singleton(fam.name()));
    }

    public static VersionUpdateFilter withinFamilies(Collection<? extends String> families) {
        if (families.isEmpty()) {
            return DEFAULT;
        }
        final Predicate<ProjectFamily> test = fam -> families.contains(fam.name());
        return new VersionUpdateFilter(){

            @Override
            public boolean shouldUpdateVersionProperty(Pom in, String propertyName, PomVersion newVersion, String currentValue) {
                return test.test(ProjectFamily.familyOf((GroupId)in.groupId()));
            }

            @Override
            public boolean shouldUpdatePomVersion(Pom in, VersionChange change) {
                return test.test(ProjectFamily.familyOf((GroupId)in.groupId()));
            }
        };
    }

    public static VersionUpdateFilter withinFamilyOrParentFamily(ProjectFamily family) {
        return VersionUpdateFilter.withinFamiliesOrParentFamily(Collections.singleton(family.name()));
    }

    public static VersionUpdateFilter withinFamiliesOrParentFamily(Collection<? extends String> families) {
        if (families.isEmpty()) {
            return DEFAULT;
        }
        final Predicate<Pom> test = pom -> {
            ProjectFamily pf = ProjectFamily.familyOf((MavenIdentified)pom);
            boolean result = families.contains(ProjectFamily.familyOf((MavenIdentified)pom).name());
            if (!result) {
                for (String s : families) {
                    ProjectFamily f = ProjectFamily.named((String)s);
                    if (!(result |= pf.isParentFamilyOf(pom.groupId()))) continue;
                    break;
                }
            }
            return result;
        };
        return new VersionUpdateFilter(){

            @Override
            public boolean shouldUpdateVersionProperty(Pom in, String propertyName, PomVersion newVersion, String currentValue) {
                return test.test(in);
            }

            @Override
            public boolean shouldUpdatePomVersion(Pom in, VersionChange change) {
                return test.test(in);
            }
        };
    }
}

