/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.refactoring;

import com.mastfrog.function.optional.ThrowingOptional;
import com.telenav.cactus.maven.model.MavenCoordinates;
import com.telenav.cactus.maven.model.MavenIdentified;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.resolver.Poms;
import com.telenav.cactus.maven.refactoring.PomRole;
import com.telenav.cactus.scope.ProjectFamily;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class PomCategorizer {
    private final Map<PomRole, Set<Pom>> pomsForKind = new EnumMap<PomRole, Set<Pom>>(PomRole.class);
    private final Map<Pom, Set<PomRole>> rolesForPom = new HashMap<Pom, Set<PomRole>>();
    private final Map<ProjectFamily, Set<Pom>> pomsForFamily = new HashMap<ProjectFamily, Set<Pom>>();
    private final Map<String, Map<String, Set<Pom>>> pomsForValueOfProperty = new HashMap<String, Map<String, Set<Pom>>>();
    private final Set<MavenCoordinates> allCoordinates = new HashSet<MavenCoordinates>();
    private final Map<Pom, Pom> parentForPom = new HashMap<Pom, Pom>();
    private final Map<Pom, Set<Pom>> childPomsByParent = new HashMap<Pom, Set<Pom>>();
    private final Poms poms;

    public PomCategorizer(Poms poms) {
        this.poms = poms;
        this.categorizePoms();
    }

    public Set<ProjectFamily> families() {
        return this.pomsForFamily.keySet();
    }

    public boolean is(Pom pom, PomRole role) {
        Set<PomRole> forPom = this.rolesForPom.get(pom);
        return forPom == null ? false : forPom.contains((Object)role);
    }

    public void eachPom(Consumer<Pom> c) {
        this.allPoms().forEach(c);
    }

    public List<Pom> allPoms() {
        return this.poms.poms();
    }

    public Map<String, Set<Pom>> pomsForValueOfProperty(String property) {
        return this.pomsForValueOfProperty.getOrDefault(property, Collections.emptyMap());
    }

    public Map<String, Map<String, Set<Pom>>> pomsForValueOfProperty() {
        return this.pomsForValueOfProperty;
    }

    public Set<MavenCoordinates> allCoordinates() {
        return this.allCoordinates;
    }

    public Map<Pom, Set<PomRole>> rolesForPom() {
        return this.rolesForPom;
    }

    public Map<ProjectFamily, Set<Pom>> pomsForFamily() {
        return this.pomsForFamily;
    }

    public void eachPomInFamily(ProjectFamily family, Consumer<Pom> c) {
        Set<Pom> result = this.pomsForFamily.get(family);
        if (result != null) {
            result.forEach(c);
        }
    }

    public Map<ProjectFamily, Set<Pom>> projectsInFamilyWithRole(PomRole role) {
        HashMap<ProjectFamily, Set<Pom>> result = new HashMap<ProjectFamily, Set<Pom>>();
        this.pomsForFamily.forEach((family, poms) -> {
            Set set = poms.stream().filter(pom -> this.is((Pom)pom, role)).collect(Collectors.toCollection(HashSet::new));
            result.put((ProjectFamily)family, set);
        });
        return result;
    }

    public Set<Pom> pomsWithRoles(PomRole first, PomRole ... more) {
        HashSet<Pom> result = new HashSet<Pom>();
        this.eachPomWithRoleIn(result::add, first, more);
        return result;
    }

    public void eachPomWithRoleIn(Consumer<Pom> c, PomRole first, PomRole ... more) {
        Set<PomRole> all = PomRole.setOf(first, more);
        for (Pom pom : this.poms) {
            EnumSet roles = EnumSet.copyOf(this.rolesForPom.get(pom));
            roles.retainAll(all);
            if (roles.isEmpty()) continue;
            c.accept(pom);
        }
    }

    public Set<Pom> pomsForFamily(ProjectFamily family) {
        return this.pomsForFamily.getOrDefault(family, Collections.emptySet());
    }

    public Set<PomRole> rolesFor(Pom pom) {
        return this.rolesForPom.getOrDefault(pom, Collections.emptySet());
    }

    public Poms poms() {
        return this.poms;
    }

    public boolean hasParent(Pom pom) {
        return this.parentForPom.containsKey(pom);
    }

    public Optional<Pom> parentOf(Pom pom) {
        return Optional.ofNullable(this.parentForPom.get(pom));
    }

    public void eachPomAndItsRoles(BiConsumer<Pom, Set<PomRole>> c) {
        PomRole.visitMapEntriesSorted(this.rolesForPom, c);
    }

    public ThrowingOptional<Pom> pomFor(MavenCoordinates coords) {
        return this.poms.get((MavenIdentified)coords);
    }

    public List<Pom> parents(Pom what) {
        ArrayList<Pom> result = new ArrayList<Pom>();
        while (what != null) {
            result.add(what);
            what = this.parentForPom.get(what);
        }
        return result;
    }

    private void onPom(PomRole role, Pom pom) {
        Set pomSet = this.pomsForKind.computeIfAbsent(role, r -> new HashSet());
        Set roles = this.rolesForPom.computeIfAbsent(pom, p -> new HashSet());
        pomSet.add(pom);
        roles.add(role);
    }

    public Set<Pom> childrenOf(Pom pom) {
        return this.childPomsByParent.getOrDefault(pom, Collections.emptySet());
    }

    public Set<Pom> descendantsOf(Pom pom) {
        HashSet<Pom> seen = new HashSet<Pom>();
        HashSet<Pom> result = new HashSet<Pom>();
        this.visitDescendantsOf(pom, seen, p -> {
            result.add((Pom)p);
            return true;
        });
        return result;
    }

    public void visitDescendantsOf(Pom pom, Predicate<Pom> addTo) {
        this.visitDescendantsOf(pom, new HashSet<Pom>(), addTo);
    }

    private void visitDescendantsOf(Pom pom, Set<Pom> seen, Predicate<Pom> addTo) {
        if (seen.contains(pom)) {
            return;
        }
        seen.add(pom);
        this.childrenOf(pom).forEach(desc -> {
            if (addTo.test((Pom)desc)) {
                this.visitDescendantsOf((Pom)desc, seen, addTo);
            }
        });
    }

    public Set<Pom> roots() {
        HashSet<Pom> result = new HashSet<Pom>();
        for (Pom pom : this.allPoms()) {
            if (this.parentForPom.containsKey(pom)) continue;
            result.add(pom);
        }
        return result;
    }

    private void recordParent(Pom child, Pom parent) {
        this.parentForPom.put(child, parent);
        Set all = this.childPomsByParent.computeIfAbsent(parent, p -> new HashSet());
        all.add(child);
    }

    private void categorizePoms() {
        HashSet parents = new HashSet();
        for (Pom pom2 : this.poms.poms()) {
            ThrowingOptional parent2 = pom2.parent();
            parent2.ifPresent(par -> {
                parents.add(par.toPlainMavenCoordinates());
                this.poms.get((MavenIdentified)par).ifPresent(parentPom -> this.recordParent(pom2, (Pom)parentPom));
            });
            this.allCoordinates.add(pom2.coordinates().toPlainMavenCoordinates());
            pom2.properties().forEach((prop, value) -> {
                Map pomsByValue = this.pomsForValueOfProperty.computeIfAbsent((String)prop, p -> new HashMap());
                Set set = pomsByValue.computeIfAbsent(value, v -> new HashSet());
                set.add(pom2);
            });
            ProjectFamily fam = ProjectFamily.familyOf((MavenIdentified)pom2);
            Set forFamily = this.pomsForFamily.computeIfAbsent(fam, f -> new HashSet());
            forFamily.add(pom2);
            if (pom2.isPomProject()) {
                if (!pom2.modules().isEmpty()) {
                    this.onPom(PomRole.BILL_OF_MATERIALS, pom2);
                    continue;
                }
                if (!parent2.isPresent()) {
                    this.onPom(PomRole.CONFIG_ROOT, pom2);
                    continue;
                }
                this.onPom(PomRole.CONFIG, pom2);
                continue;
            }
            this.onPom(PomRole.JAVA, pom2);
        }
        parents.forEach(parent -> this.poms.get((MavenIdentified)parent).ifPresent(parentPom -> this.onPom(PomRole.PARENT, (Pom)parentPom)));
        for (Pom pom2 : this.poms.poms()) {
            Set<PomRole> roles2 = this.rolesForPom.get(pom2);
            if (roles2 != null && !roles2.isEmpty()) continue;
            this.onPom(PomRole.UNKNOWN, pom2);
        }
        this.rolesForPom.forEach((pom, roles) -> {
            if (roles.contains((Object)PomRole.PARENT) && roles.contains((Object)PomRole.BILL_OF_MATERIALS)) {
                if (pom.parent().isPresent()) {
                    roles.add(PomRole.CONFIG_ROOT);
                } else {
                    roles.add(PomRole.CONFIG);
                }
            }
        });
    }
}

