/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.refactoring;

import com.mastfrog.util.preconditions.Checks;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public enum PomRole {
    PARENT,
    BILL_OF_MATERIALS,
    CONFIG,
    CONFIG_ROOT,
    JAVA,
    UNKNOWN;


    public String toString() {
        return this.name().replace('_', '-').toLowerCase();
    }

    public static Set<PomRole> setOf(PomRole first, PomRole ... more) {
        EnumSet<PomRole> result = EnumSet.of((PomRole)((Object)Checks.notNull((String)"first", (Object)((Object)first))));
        for (int i = 0; i < more.length; ++i) {
            result.add(more[i]);
        }
        return result;
    }

    public static <T extends Comparable<? super T>> void visitMapEntriesSorted(Map<T, Set<PomRole>> map, BiConsumer<T, Set<PomRole>> roleConsumer) {
        ArrayList<Map.Entry<Map.Entry, Set<PomRole>>> entries = new ArrayList<Map.Entry<Map.Entry, Set<PomRole>>>(map.entrySet());
        entries.sort((a, b) -> {
            int result = Integer.compare(PomRole.maxOrdinal((Set)a.getValue()), PomRole.maxOrdinal((Set)b.getValue()));
            if (result == 0) {
                result = ((Comparable)a.getKey()).compareTo(b.getKey());
            }
            return result;
        });
        entries.forEach(entry -> roleConsumer.accept((Comparable)entry.getKey(), (Set)entry.getValue()));
    }

    private static <E extends Enum<E>> int maxOrdinal(Set<E> set) {
        int result = -1;
        for (Enum e : set) {
            result = Integer.max(result, e.ordinal());
        }
        return result;
    }
}

