/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.refactoring;

import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.ResolvablePomElement;
import com.telenav.cactus.maven.refactoring.VersionProperty;
import java.util.Optional;

final class PropertyChange<T, E extends ResolvablePomElement<E>> {
    private final VersionProperty<T> property;
    private final E newValue;

    private PropertyChange(VersionProperty<T> property, E newValue) {
        this.property = property;
        this.newValue = newValue;
    }

    static <T, E extends ResolvablePomElement<E>> Optional<PropertyChange<T, E>> propertyChange(VersionProperty<T> property, E replacement) {
        if (((ResolvablePomElement)Checks.notNull((String)"replacement", replacement)).text().equals(((VersionProperty)Checks.notNull((String)"property", property)).oldValue())) {
            return Optional.empty();
        }
        return Optional.of(new PropertyChange<T, E>(property, replacement));
    }

    public E newValue() {
        return this.newValue;
    }

    public String propertyName() {
        return this.property.property();
    }

    public String oldValue() {
        return this.property.oldValue();
    }

    public Pom foo() {
        return this.property.pom();
    }

    public String toString() {
        return this.property + " -> " + this.newValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || PropertyChange.class != o.getClass()) {
            return false;
        }
        PropertyChange pc = (PropertyChange)o;
        return pc.property.equals(this.property) && pc.newValue.equals(this.newValue);
    }

    public int hashCode() {
        return (this.newValue.hashCode() + 1) * (71 * this.property.hashCode());
    }
}

