/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.refactoring;

import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.PomVersion;
import com.telenav.cactus.maven.model.internal.PomFile;
import com.telenav.cactus.maven.model.resolver.Poms;
import com.telenav.cactus.maven.refactoring.PomCategorizer;
import com.telenav.cactus.maven.refactoring.PropertyChange;
import com.telenav.cactus.maven.refactoring.VersionIndicatingProperties;
import com.telenav.cactus.maven.refactoring.VersionProperty;
import com.telenav.cactus.maven.xml.AbstractXMLUpdater;
import com.telenav.cactus.maven.xml.XMLFile;
import com.telenav.cactus.maven.xml.XMLReplacer;
import com.telenav.cactus.maven.xml.XMLTextContentReplacement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.w3c.dom.Document;

public class PropertyHomogenizer {
    private final PomCategorizer categorizer;
    private final VersionIndicatingProperties potentialPropertyChanges;
    private final Map<Pom, PropertyChange<?, PomVersion>> changes = new HashMap();
    private boolean pretend;

    public PropertyHomogenizer(Poms poms) {
        this.categorizer = new PomCategorizer(poms);
        this.potentialPropertyChanges = VersionIndicatingProperties.create(this.categorizer);
    }

    public PropertyHomogenizer pretend() {
        this.pretend = true;
        return this;
    }

    public Set<Path> go(Consumer<String> log) throws Exception {
        this.collectProperties();
        if (this.changes.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Path> result = new HashSet<Path>();
        ArrayList<XMLTextContentReplacement> replacements = new ArrayList<XMLTextContentReplacement>();
        for (Map.Entry<Pom, PropertyChange<?, PomVersion>> e : this.changes.entrySet()) {
            log.accept(" * " + e.getValue());
            PomFile file = PomFile.of((Pom)e.getKey());
            replacements.add(new XMLTextContentReplacement((XMLFile)file, "/project/properties/" + e.getValue().propertyName(), e.getValue().newValue().text()));
        }
        AbstractXMLUpdater.openAll(replacements, () -> {
            for (AbstractXMLUpdater rep : replacements) {
                Document doc = rep.replace();
                if (doc == null) continue;
                if (!this.pretend) {
                    XMLReplacer.writeXML((Document)doc, (Path)rep.path());
                }
                log.accept((this.pretend ? "(pretend) " : "") + " Wrote " + rep.path());
                result.add(rep.path());
            }
            return null;
        });
        return result;
    }

    private void collectProperties() {
        HashMap<String, Set> propertyInstances = new HashMap<String, Set>();
        HashMap<String, Set> versions = new HashMap<String, Set>();
        Set<VersionProperty<?>> all = this.potentialPropertyChanges.all();
        for (VersionProperty<?> vp : all) {
            Set vers2 = versions.computeIfAbsent(vp.property(), k -> new HashSet());
            vers2.add(PomVersion.of((String)vp.oldValue()));
            Set props = propertyInstances.computeIfAbsent(vp.property(), k -> new HashSet());
            props.add(vp);
        }
        versions.forEach((prop, vers) -> {
            if (vers.size() > 1) {
                LinkedList candidates = new LinkedList(vers);
                Collections.sort(candidates);
                PomVersion best = (PomVersion)candidates.getLast();
                for (VersionProperty vp : (Set)propertyInstances.get(prop)) {
                    if (best.is(vp.oldValue())) continue;
                    PropertyChange.propertyChange(vp, best).ifPresent(chg -> this.changes.put(vp.pom(), (PropertyChange<?, PomVersion>)chg));
                }
            }
        });
    }
}

