/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.refactoring;

import com.mastfrog.function.state.Bool;
import com.mastfrog.util.preconditions.Exceptions;
import com.telenav.cactus.maven.model.MavenArtifactCoordinates;
import com.telenav.cactus.maven.model.MavenCoordinates;
import com.telenav.cactus.maven.model.MavenIdentified;
import com.telenav.cactus.maven.model.MavenVersioned;
import com.telenav.cactus.maven.model.Pom;
import com.telenav.cactus.maven.model.PomVersion;
import com.telenav.cactus.maven.model.VersionChange;
import com.telenav.cactus.maven.model.VersionChangeMagnitude;
import com.telenav.cactus.maven.model.VersionFlavor;
import com.telenav.cactus.maven.model.VersionFlavorChange;
import com.telenav.cactus.maven.model.published.PublishChecker;
import com.telenav.cactus.maven.refactoring.PomCategorizer;
import com.telenav.cactus.maven.refactoring.PomRole;
import com.telenav.cactus.maven.refactoring.PropertyChange;
import com.telenav.cactus.maven.refactoring.SuperpomBumpPolicy;
import com.telenav.cactus.maven.refactoring.VersionChangeUpdatesCollector;
import com.telenav.cactus.maven.refactoring.VersionIndicatingProperties;
import com.telenav.cactus.maven.refactoring.VersionMismatchPolicy;
import com.telenav.cactus.maven.refactoring.VersionMismatchPolicyOutcome;
import com.telenav.cactus.scope.ProjectFamily;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;

class VersionUpdateFinder {
    final VersionChangeUpdatesCollector changes;
    final PomCategorizer categories;
    private final VersionIndicatingProperties potentialPropertyChanges;
    private final Map<ProjectFamily, VersionChange> familyVersionChanges;
    private final Map<ProjectFamily, VersionChange> syntheticFamilyVersionChanges = new HashMap<ProjectFamily, VersionChange>();
    private final Set<ProjectFamily> completedFamilies = new HashSet<ProjectFamily>();
    private final SuperpomBumpPolicy superpomBumpPolicy;
    private final VersionMismatchPolicy versionMismatchPolicy;
    private final PublishChecker publishChecker;

    VersionUpdateFinder(VersionChangeUpdatesCollector changes, PomCategorizer categories, VersionIndicatingProperties potentialPropertyChanges, Map<ProjectFamily, VersionChange> familyVersionChanges, SuperpomBumpPolicy superpomBumpPolicy, VersionMismatchPolicy versionMismatchPolicy, PublishChecker publishChecker) {
        this.changes = changes;
        this.categories = categories;
        this.potentialPropertyChanges = potentialPropertyChanges;
        this.familyVersionChanges = familyVersionChanges;
        this.superpomBumpPolicy = superpomBumpPolicy;
        this.versionMismatchPolicy = versionMismatchPolicy;
        this.publishChecker = publishChecker;
    }

    public void go() {
        boolean noFamilyChanges = this.familyVersionChanges.isEmpty();
        Map<Pom, VersionMismatchPolicyOutcome> mismatchOutcomes = null;
        do {
            if (noFamilyChanges && !this.changes.pomVersionChanges().isEmpty()) {
                this.cascadeCurrentChanges();
            }
            Map<Pom, VersionMismatchPolicyOutcome> outcomes = this.findUpdates();
            if (mismatchOutcomes == null) {
                mismatchOutcomes = outcomes;
                continue;
            }
            mismatchOutcomes.putAll(outcomes);
        } while (this.changes.hasChanges());
        this.pruneDuplicateVersions();
        this.findSuperpomsThatNeedBumping();
        StringBuilder abortMessage = new StringBuilder();
        mismatchOutcomes.forEach((pom, outcome) -> {
            if (this.versionMismatches().contains(pom)) {
                switch (outcome) {
                    case ABORT: {
                        if (abortMessage.length() > 0) {
                            abortMessage.append(", ");
                        }
                        abortMessage.append(pom);
                    }
                }
            }
        });
        if (abortMessage.length() > 0) {
            throw new IllegalStateException("Encountered version mismatches with outcome ABORT: " + abortMessage);
        }
    }

    private void findSuperpomsThatNeedBumping() {
        if (this.publishChecker != null && this.superpomBumpPolicy.isBumpVersion()) {
            HashSet alsoBump = new HashSet();
            this.categories.eachPomWithRoleIn(pom -> {
                if (this.changes.hasVersionUpdateFor((Pom)pom)) {
                    return;
                }
                HashSet possibleUpdates = new HashSet();
                this.categories.childrenOf((Pom)pom).forEach(child -> {
                    boolean alreadyChanging = this.changes.hasParentUpdateFor((Pom)child);
                    if (!alreadyChanging) {
                        possibleUpdates.add(child);
                    }
                });
                HashSet<Pom> allDescendants = new HashSet<Pom>();
                for (Object child2 : possibleUpdates) {
                    allDescendants.addAll(this.categories.descendantsOf((Pom)child2));
                }
                boolean hasDescendantInTargetFamilies = false;
                for (Pom desc : allDescendants) {
                    if (!this.familyVersionChanges.containsKey(ProjectFamily.familyOf((MavenIdentified)desc))) continue;
                    hasDescendantInTargetFamilies = true;
                    break;
                }
                boolean needRepublish = false;
                if (hasDescendantInTargetFamilies) {
                    try {
                        needRepublish = this.publishChecker.check((MavenArtifactCoordinates)pom).differs();
                    }
                    catch (IOException | InterruptedException | URISyntaxException ex) {
                        Exceptions.chuck((Throwable)ex);
                    }
                }
                if (needRepublish) {
                    PomVersion oldVersion = pom.version();
                    oldVersion.updatedWith(this.superpomBumpPolicy.minimalMagnitudeFor(oldVersion), this.superpomBumpPolicy.changeFor(oldVersion)).ifPresent(newVersion -> VersionChange.versionChange((PomVersion)oldVersion, (PomVersion)newVersion).ifPresent(versionChange -> {
                        this.changes.changeParentVersion((Pom)pom, (Pom)pom, (VersionChange)versionChange);
                        this.cascadeChange((Pom)pom, (VersionChange)versionChange);
                    }));
                }
            }, PomRole.CONFIG, PomRole.CONFIG_ROOT);
        }
    }

    private Map<Pom, VersionMismatchPolicyOutcome> findUpdates() {
        this.collectPropertyChanges();
        this.applyFamilyVersionChanges();
        this.processVersionMismatches();
        this.updateSyntheticFamilyVersionChanges();
        return this.applyVersionMismatchPolicy();
    }

    void cascadeInitialPomChanges() {
        this.pomVersionChanges().forEach((pom, vc) -> this.cascadeChange((Pom)pom, (VersionChange)vc));
    }

    Map<ProjectFamily, VersionChange> allFamilyChanges() {
        HashMap<ProjectFamily, VersionChange> map = new HashMap<ProjectFamily, VersionChange>(this.familyVersionChanges);
        map.putAll(this.syntheticFamilyVersionChanges);
        return map;
    }

    private boolean updateSyntheticFamilyVersionChanges() {
        Bool changed = Bool.create();
        for (ProjectFamily fam : this.categories.families()) {
            if (this.familyVersionChanges.containsKey(fam) || this.syntheticFamilyVersionChanges.containsKey(fam) || !this.isFamilyEffectivelyUpdated(fam)) continue;
            Set<Pom> changedPomsInFamily = this.changes.changedPomsInFamily(fam);
            PomVersion.mostCommonVersion(changedPomsInFamily).ifPresent(mostCommonVersion -> PomVersion.mostCommonVersion(this.categories.pomsForFamily(fam)).ifPresent(oldVersion -> oldVersion.to(mostCommonVersion).ifPresent(newChange -> {
                changed.set();
                this.syntheticFamilyVersionChanges.put(fam, (VersionChange)newChange);
            })));
        }
        return changed.getAsBoolean();
    }

    private void collectPropertyChanges() {
        this.categories.allPoms().forEach(pom -> this.potentialPropertyChanges.collectMatches((Pom)pom, (role, versionProperty) -> {
            Bool changed = Bool.create();
            if (role.isProject()) {
                MavenCoordinates coords = (MavenCoordinates)versionProperty.pointsTo();
                this.categories.pomFor(coords).ifPresent(pomOfReVersionedProject -> {
                    VersionChange change;
                    if (pomOfReVersionedProject.hasExplicitVersion()) {
                        change = this.pomVersionChanges().get(pomOfReVersionedProject);
                    } else {
                        change = this.pomVersionChanges().get(pomOfReVersionedProject);
                        if (change == null) {
                            change = this.parentVersionChanges().get(pomOfReVersionedProject);
                        }
                    }
                    if (change != null) {
                        PomVersion newValue = change.version(role.isPrevious());
                        PropertyChange.propertyChange(versionProperty, newValue).ifPresent(newPropertyChange -> changed.set(this.changes.changeProperty((Pom)pom, (PropertyChange<?, PomVersion>)newPropertyChange).isChange()));
                    }
                });
            } else {
                ProjectFamily family = (ProjectFamily)versionProperty.pointsTo();
                VersionChange familyVersionChange = this.familyVersionChanges.get(family);
                if (this.pomVersionChanges().containsKey(pom)) {
                    VersionChange pomChange = this.pomVersionChanges().get(pom);
                    if (pomChange.oldVersion().is(versionProperty.oldValue())) {
                        familyVersionChange = this.pomVersionChanges().get(pom);
                    } else {
                        changed.set(true);
                    }
                }
                if (familyVersionChange != null) {
                    PomVersion newVersion = familyVersionChange.version(role.isPrevious());
                    PropertyChange.propertyChange(versionProperty, newVersion).ifPresent(newPropertyChange -> {
                        boolean reallyHaveAChange = this.changes.changeProperty((Pom)pom, (PropertyChange<?, PomVersion>)newPropertyChange).isChange();
                        changed.set(reallyHaveAChange);
                    });
                }
            }
            changed.ifTrue(() -> {
                if (this.categories.is((Pom)pom, PomRole.CONFIG) || this.categories.is((Pom)pom, PomRole.CONFIG_ROOT)) {
                    ProjectFamily fam = ProjectFamily.familyOf((MavenIdentified)pom);
                    VersionChange vc = this.familyVersionChanges.get(fam);
                    if (vc != null && vc.oldVersion().equals((Object)pom.version())) {
                        if (this.changes.changePomVersion((Pom)pom, vc).isChange()) {
                            this.cascadeChange((Pom)pom, vc);
                        }
                    } else {
                        Consumer<PomVersion> newVersionConsumer = nue -> pom.version().to(nue).ifPresent(updatedPomVersion -> {
                            if (this.changes.changePomVersion((Pom)pom, (VersionChange)updatedPomVersion).isChange()) {
                                this.cascadeChange((Pom)pom, (VersionChange)updatedPomVersion);
                            }
                        });
                        if (vc != null && this.superpomBumpPolicy.isBumpVersion()) {
                            pom.version().updatedWith(this.superpomBumpPolicy.magnitudeFor(vc), this.superpomBumpPolicy.changeFor(vc.newVersion())).ifPresent(newVersionConsumer);
                        } else if (this.superpomBumpPolicy.isBumpVersion()) {
                            pom.version().updatedWith(VersionChangeMagnitude.DOT, VersionFlavorChange.UNCHANGED).ifPresent(newVersionConsumer);
                        }
                    }
                }
            });
        }));
    }

    private void applyFamilyVersionChanges() {
        this.allFamilyChanges().forEach((family, expectedVersionChange) -> {
            if (this.completedFamilies.contains(family)) {
                return;
            }
            this.categories.eachPomInFamily((ProjectFamily)family, pom -> {
                if (!this.pomVersionChanges().containsKey(pom) && !this.versionMismatches().contains(pom)) {
                    boolean match = expectedVersionChange.oldVersion().isVersionOf((MavenVersioned)pom);
                    if (!match) {
                        this.changes.addVersionMismatch((Pom)pom);
                    } else if (match) {
                        if (pom.hasExplicitVersion()) {
                            this.changes.changePomVersion((Pom)pom, (VersionChange)expectedVersionChange);
                        } else {
                            VersionChangeUpdatesCollector.ChangeResult result;
                            Optional<Pom> par = this.categories.parentOf((Pom)pom);
                            if (par.isPresent() && (result = this.changes.changeParentVersion((Pom)pom, par.get(), (VersionChange)expectedVersionChange)).isFiltered()) {
                                this.changes.changePomVersion((Pom)pom, (VersionChange)expectedVersionChange);
                            }
                        }
                    }
                }
            });
            this.completedFamilies.add((ProjectFamily)family);
        });
    }

    private void processVersionMismatches() {
        if (!this.versionMismatches().isEmpty() && this.superpomBumpPolicy.isBumpVersion()) {
            this.eachVersionMismatch((pom, familyOrPomChange) -> {
                if (this.categories.is((Pom)pom, PomRole.CONFIG) || this.categories.is((Pom)pom, PomRole.CONFIG_ROOT)) {
                    VersionFlavorChange flavorChange = VersionFlavorChange.UNCHANGED;
                    VersionChangeMagnitude magnitudeChange = VersionChangeMagnitude.DOT;
                    if (familyOrPomChange != null && this.familyVersionChanges.containsKey(ProjectFamily.familyOf((MavenIdentified)pom))) {
                        flavorChange = this.superpomBumpPolicy.changeFor(familyOrPomChange.newVersion());
                        magnitudeChange = this.superpomBumpPolicy.magnitudeFor((VersionChange)familyOrPomChange);
                    }
                    PomVersion newVersion = (PomVersion)pom.version().updatedWith(magnitudeChange, flavorChange).get();
                    VersionChange vc = new VersionChange(pom.version(), newVersion);
                    if (!pom.hasExplicitVersion()) {
                        List<Pom> parents = this.categories.parents((Pom)pom);
                        for (Pom par : parents) {
                            if (!par.version().equals((Object)pom.version())) continue;
                            if (par.hasExplicitVersion()) {
                                this.changes.changePomVersion(par, vc);
                            } else {
                                Optional<Pom> parPar = this.categories.parentOf((Pom)pom);
                                if (parPar.isPresent() && this.changes.changeParentVersion(par, parPar.get(), vc).isFiltered()) {
                                    this.changes.changePomVersion((Pom)pom, vc);
                                }
                            }
                            return true;
                        }
                    } else {
                        this.changes.changePomVersion((Pom)pom, vc);
                        return true;
                    }
                    return true;
                }
                return false;
            });
        }
    }

    private Map<Pom, VersionMismatchPolicyOutcome> applyVersionMismatchPolicy() {
        HashMap<Pom, VersionMismatchPolicyOutcome> outcomes = new HashMap<Pom, VersionMismatchPolicyOutcome>();
        this.eachVersionMismatch((pom, expectedChangeOrNull) -> {
            if (expectedChangeOrNull != null) {
                VersionMismatchPolicyOutcome outcome = this.versionMismatchPolicy.mismatchEncountered((Pom)pom, (VersionChange)expectedChangeOrNull, this.categories.rolesFor((Pom)pom));
                outcomes.put((Pom)pom, outcome);
                switch (outcome) {
                    case ABORT: {
                        break;
                    }
                    case SKIP: {
                        return true;
                    }
                    case COERCE_TO_TARGET_VERSION: {
                        this.changes.changePomVersion((Pom)pom, (VersionChange)expectedChangeOrNull);
                        return true;
                    }
                    case BUMP: {
                        VersionFlavor newFlavor = expectedChangeOrNull.newVersion().flavor();
                        Optional res = pom.version().updatedWith(VersionChangeMagnitude.DOT, VersionFlavorChange.between((VersionFlavor)expectedChangeOrNull.oldVersion().flavor(), (VersionFlavor)newFlavor));
                        if (res.isPresent()) {
                            this.changes.changePomVersion((Pom)pom, new VersionChange(pom.version(), (PomVersion)res.get()));
                        }
                        return true;
                    }
                    default: {
                        throw new AssertionError(outcome);
                    }
                }
            }
            return false;
        });
        return outcomes;
    }

    private void cascadeChange(Pom pom, VersionChange chg) {
        for (Pom kid : this.categories.childrenOf(pom)) {
            if (this.parentVersionChanges().containsKey(kid) || !this.changes.changeParentVersion(kid, pom, chg).isChange()) continue;
            this.cascadeChange(kid, chg);
        }
    }

    private void eachVersionMismatch(BiPredicate<Pom, VersionChange> c) {
        for (Pom pom : new HashSet<Pom>(this.versionMismatches())) {
            if (!this.versionMismatches().contains(pom)) continue;
            VersionChange change = this.pomVersionChanges().get(pom);
            if (change == null) {
                change = this.familyVersionChanges.get(ProjectFamily.familyOf((MavenIdentified)pom));
            }
            if (change != null && !c.test(pom, change)) continue;
            this.changes.removeVersionMismatch(pom);
        }
    }

    private boolean isFamilyEffectivelyUpdated(ProjectFamily family) {
        Map<ProjectFamily, Set<Pom>> javaProjects = this.categories.projectsInFamilyWithRole(PomRole.JAVA);
        Map<ProjectFamily, Set<Pom>> boms = this.categories.projectsInFamilyWithRole(PomRole.BILL_OF_MATERIALS);
        HashSet mix = new HashSet();
        if (javaProjects.containsKey(family)) {
            mix.addAll(javaProjects.get(family));
        }
        if (boms.containsKey(family)) {
            mix.addAll(boms.get(family));
        }
        return this.changes.allChangedPoms().containsAll(mix);
    }

    private Map<Pom, VersionChange> pomVersionChanges() {
        return this.changes.pomVersionChanges();
    }

    private Map<Pom, VersionChange> parentVersionChanges() {
        return this.changes.parentVersionChanges();
    }

    private Set<Pom> versionMismatches() {
        return this.changes.versionMismatches();
    }

    private void cascadeCurrentChanges() {
        HashMap<Pom, VersionChange> ch = new HashMap<Pom, VersionChange>(this.changes.pomVersionChanges());
        HashSet seen = new HashSet();
        while (!ch.isEmpty()) {
            ch.forEach((pom, ver) -> {
                seen.add(pom);
                this.cascadeChange((Pom)pom, (VersionChange)ver);
            });
            ch.putAll(this.changes.pomVersionChanges());
            for (Pom p : seen) {
                ch.remove(p);
            }
        }
    }

    private void pruneDuplicateVersions() {
        new HashMap<Pom, VersionChange>(this.changes.pomVersionChanges()).forEach((pom, verChange) -> {
            VersionChange parentChange = this.changes.parentVersionChanges().get(pom);
            if (parentChange != null && verChange.newVersion().equals((Object)parentChange.version())) {
                this.categories.parentOf((Pom)pom).ifPresent(parentPom -> {
                    if (!pom.hasExplicitVersion()) {
                        this.changes.removePomVersionChange((Pom)pom);
                    }
                });
            }
        });
    }
}

