/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.xml;

import com.mastfrog.function.throwing.ThrowingSupplier;
import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.maven.xml.XMLFile;
import com.telenav.cactus.maven.xml.XMLReplacer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.w3c.dom.Document;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AbstractXMLUpdater
implements Comparable<AbstractXMLUpdater> {
    protected final XMLFile in;

    public static <T> T openAll(Iterable<AbstractXMLUpdater> iter, ThrowingSupplier<T> supp) throws Exception {
        Iterator<AbstractXMLUpdater> it = iter.iterator();
        if (!it.hasNext()) {
            return (T)supp.get();
        }
        return it.next().run(it, supp);
    }

    protected AbstractXMLUpdater(XMLFile in) {
        this.in = (XMLFile)Checks.notNull((String)"in", (Object)in);
    }

    public Path path() {
        return this.in.path();
    }

    public abstract Document replace() throws Exception;

    @Override
    public final int compareTo(AbstractXMLUpdater o) {
        return this.in.path().toString().compareTo(o.in.path().toString());
    }

    final <T> T run(Iterator<AbstractXMLUpdater> iter, ThrowingSupplier<T> supp) throws Exception {
        if (!iter.hasNext()) {
            return this.in.inContext(supp);
        }
        return this.in.inContext(() -> ((AbstractXMLUpdater)iter.next()).run(iter, supp));
    }

    public static Set<Path> applyAll(Collection<? extends AbstractXMLUpdater> changes, boolean pretend, Consumer<String> msgs) throws Exception {
        ArrayList<AbstractXMLUpdater> replacers = new ArrayList<AbstractXMLUpdater>(changes);
        Collections.sort(replacers);
        return (Set)AbstractXMLUpdater.openAll(replacers, () -> {
            HashSet<Path> result = new HashSet<Path>();
            LinkedHashMap<Path, Document> docForPath = new LinkedHashMap<Path, Document>();
            for (AbstractXMLUpdater rep : replacers) {
                Document changed = rep.replace();
                if (changed == null) continue;
                Document old = (Document)docForPath.get(rep.path());
                if (old != changed && old != null) {
                    throw new AssertionError((Object)("Context did not hold - " + old + " vs " + changed + " for " + rep.path()));
                }
                msgs.accept(" Apply: " + rep);
                docForPath.put(rep.path(), changed);
            }
            String mode = pretend ? "(pretend) " : "";
            for (Map.Entry e : docForPath.entrySet()) {
                if (!pretend) {
                    XMLReplacer.writeXML((Document)e.getValue(), (Path)e.getKey());
                }
                result.add((Path)e.getKey());
                msgs.accept(mode + "Rewrote " + e.getKey());
            }
            return result;
        });
    }
}

