/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.xml;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.function.throwing.ThrowingBiConsumer;
import com.mastfrog.function.throwing.ThrowingBiFunction;
import com.mastfrog.function.throwing.ThrowingConsumer;
import com.mastfrog.function.throwing.ThrowingFunction;
import com.mastfrog.function.throwing.ThrowingQuadFunction;
import com.mastfrog.function.throwing.ThrowingRunnable;
import com.mastfrog.function.throwing.ThrowingSupplier;
import com.mastfrog.function.throwing.ThrowingTriConsumer;
import com.mastfrog.function.throwing.ThrowingTriFunction;
import com.mastfrog.util.preconditions.Checks;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class XMLFile {
    private static final XPathFactory XPATH_FACTORY = XPathFactory.newInstance();
    protected static final ThreadLocal<XPath> XPATH = ThreadLocal.withInitial(() -> XPATH_FACTORY.newXPath());
    protected final ThreadLocal<Document> docContext = new ThreadLocal();
    private final Path path;

    public XMLFile(Path path) {
        this.path = (Path)Checks.notNull((String)"path", (Object)path);
    }

    public Document document() throws ParserConfigurationException, SAXException, IOException {
        Document result = this.docContext.get();
        if (result == null) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            result = db.parse(this.path.toFile());
        }
        return result;
    }

    protected static Map<String, String> toStringMap(Map<String, Node> m) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        m.forEach((k, v) -> result.put((String)k, v.getTextContent()));
        return result;
    }

    protected static String nodeText(String key, Map<String, Node> m) {
        Node n = m.get(key);
        if (n != null) {
            return n.getTextContent().trim();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T inContext(ThrowingFunction<Document, T> supp) throws Exception {
        Document doc;
        Document oldDoc = this.docContext.get();
        if (oldDoc == null) {
            doc = this.document();
            this.docContext.set(doc);
        } else {
            doc = oldDoc;
        }
        try {
            Object object = supp.apply((Object)doc);
            return (T)object;
        }
        finally {
            if (oldDoc == null) {
                this.docContext.remove();
            }
        }
    }

    public final <T> T inContext(ThrowingSupplier<T> supp) throws Exception {
        return this.inContext(doc -> supp.get());
    }

    public final void inContextRun(ThrowingRunnable supp) throws Exception {
        this.inContext(() -> {
            supp.run();
            return null;
        });
    }

    public final ThrowingOptional<String> nodeText(String query) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        return this.nodeQuery(query).map(nd -> nd.getTextContent().trim());
    }

    public final List<String> nodeTextList(String query) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        ArrayList<String> result = new ArrayList<String>(32);
        this.nodesQuery(query).ifPresent(list -> {
            for (int i = 0; i < list.getLength(); ++i) {
                Node no = list.item(i);
                String txt = no.getTextContent();
                if (txt == null || (txt = txt.trim()).isEmpty()) continue;
                result.add(txt);
            }
        });
        return result;
    }

    public final ThrowingOptional<Node> nodeQuery(String query) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        XPath xpath = XMLFile.xpath();
        Document doc = this.document();
        XPathExpression findPackaging = xpath.compile(query);
        Node result = (Node)findPackaging.evaluate(doc, XPathConstants.NODE);
        return ThrowingOptional.ofNullable((Object)result);
    }

    public final boolean nodeQuery(String query, ThrowingConsumer<Node> c) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        ThrowingOptional<Node> nd = this.nodeQuery(query);
        nd.ifPresent(c);
        return nd.isPresent();
    }

    public final <T> ThrowingOptional<T> nodeQueryGet(String query, ThrowingFunction<Node, T> c) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        ThrowingOptional<Node> nd = this.nodeQuery(query);
        return nd.map(c);
    }

    public final boolean nodeQuery(String query1, String query2, ThrowingBiConsumer<Node, Node> c) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        ThrowingOptional<Node> nd1 = this.nodeQuery(query1);
        ThrowingOptional<Node> nd2 = this.nodeQuery(query2);
        nd1.ifPresent(n1 -> nd2.ifPresent(n2 -> c.accept(n1, n2)));
        return nd1.isPresent() && nd2.isPresent();
    }

    public final boolean nodeQuery(String query1, String query2, String query3, ThrowingTriConsumer<Node, Node, Node> c) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        ThrowingOptional<Node> nd1 = this.nodeQuery(query1);
        ThrowingOptional<Node> nd2 = this.nodeQuery(query2);
        ThrowingOptional<Node> nd3 = this.nodeQuery(query3);
        nd1.ifPresent(n1 -> nd2.ifPresent(n2 -> nd3.ifPresent(n3 -> c.accept(n1, n2, n3))));
        return nd1.isPresent() && nd2.isPresent() && nd3.isPresent();
    }

    public final <T> ThrowingOptional<T> nodeQueryGet(String query1, String query2, ThrowingBiFunction<Node, Node, T> c) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        ThrowingOptional<Node> nd1 = this.nodeQuery(query1);
        return nd1.flatMapThrowing(n1 -> {
            ThrowingOptional<Node> nd2 = this.nodeQuery(query2);
            return nd2.map(n2 -> c.apply(n1, n2));
        });
    }

    public final <T> ThrowingOptional<T> nodeQueryGet(String query1, String query2, String query3, ThrowingTriFunction<Node, Node, Node, T> c) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        ThrowingOptional<Node> nd1 = this.nodeQuery(query1);
        return nd1.flatMapThrowing(n1 -> {
            ThrowingOptional<Node> nd2 = this.nodeQuery(query2);
            return nd2.flatMapThrowing(n2 -> {
                ThrowingOptional<Node> nd3 = this.nodeQuery(query3);
                return nd3.map(n3 -> c.apply(n1, n2, n3));
            });
        });
    }

    public final <T> ThrowingOptional<T> nodeQueryGet(String query1, String query2, String query3, String query4, ThrowingQuadFunction<Node, Node, Node, Node, T> c) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        ThrowingOptional<Node> nd1 = this.nodeQuery(query1);
        return nd1.flatMapThrowing(n1 -> {
            ThrowingOptional<Node> nd2 = this.nodeQuery(query2);
            return nd2.flatMapThrowing(n2 -> {
                ThrowingOptional<Node> nd3 = this.nodeQuery(query3);
                return nd3.flatMapThrowing(n3 -> {
                    ThrowingOptional<Node> nd4 = this.nodeQuery(query4);
                    return nd4.map(n4 -> c.apply(n1, n2, n3, n4));
                });
            });
        });
    }

    public final ThrowingOptional<NodeList> nodesQuery(String query) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        XPath xpath = XMLFile.xpath();
        Document doc = this.document();
        XPathExpression findPackaging = xpath.compile(query);
        NodeList result = (NodeList)findPackaging.evaluate(doc, XPathConstants.NODESET);
        if (result == null || result.getLength() == 0) {
            return ThrowingOptional.empty();
        }
        return ThrowingOptional.of((Object)result);
    }

    protected static XPath xpath() {
        return XPATH.get();
    }

    public final Path path() {
        return this.path;
    }
}

