/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.xml;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class XMLReplacer {
    public static void writeXML(Document doc, Path path) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult res = new StreamResult(out);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(doc), res);
        String munge = new String(out.toByteArray(), "UTF-8");
        String oldContent = null;
        if (Files.exists(path, new LinkOption[0]) && Files.isReadable(path)) {
            oldContent = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        }
        munge = XMLReplacer.restoreOriginalHead(oldContent, munge);
        Files.write(path, munge.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static String restoreOriginalHead(String orig, String mangled) {
        String newTail;
        if (orig == null) {
            if (mangled.length() > 0 && mangled.charAt(mangled.length() - 1) != '\n') {
                return mangled + "\n";
            }
            return mangled;
        }
        int oix = orig.indexOf("<project");
        int nix = mangled.indexOf("<project");
        if (oix < 0 || nix < 0) {
            return mangled;
        }
        int oend = orig.indexOf(62, oix + 1);
        int nend = mangled.indexOf(62, nix + 1);
        if (oend < 0 || nend < 0) {
            return mangled;
        }
        String oldHead = orig.substring(0, oend + 1);
        return oldHead + newTail + (Serializable)((newTail = mangled.substring(nend + 1, mangled.length())).charAt(newTail.length() - 1) == '\n' ? "" : Character.valueOf('\n'));
    }

    private XMLReplacer() {
        throw new AssertionError();
    }
}

