/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.xml;

import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.maven.xml.AbstractXMLUpdater;
import com.telenav.cactus.maven.xml.XMLFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class XMLVersionElementAdder
extends AbstractXMLUpdater {
    private final String version;

    public XMLVersionElementAdder(XMLFile file, String version) {
        super(file);
        this.version = (String)Checks.notNull((String)"version", (Object)version);
    }

    @Override
    public Document replace() throws Exception {
        return (Document)this.in.inContext(doc -> (Document)this.in.nodeQuery("/project/artifactId").map(nd -> {
            String indent = "\n    ";
            Text indentNode = doc.createTextNode(indent);
            Node par = nd.getParentNode();
            Node target = nd.getNextSibling();
            if (target == null) {
                target = nd;
            }
            par.insertBefore(indentNode, target);
            Element versionElement = doc.createElement("version");
            versionElement.setTextContent(this.version);
            par.insertBefore(versionElement, target);
            return doc;
        }).orElse(null));
    }

    public String toString() {
        return "add <version>" + this.version + "</version> in " + this.in;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || XMLVersionElementAdder.class != o.getClass()) {
            return false;
        }
        XMLVersionElementAdder v = (XMLVersionElementAdder)o;
        return v.in.path().equals(this.in.path()) && v.version.equals(this.version);
    }
}

