/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.xml;

import com.mastfrog.function.optional.ThrowingOptional;
import com.telenav.cactus.maven.xml.AbstractXMLUpdater;
import com.telenav.cactus.maven.xml.XMLFile;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class XMLElementRemoval
extends AbstractXMLUpdater {
    private final String query;

    public XMLElementRemoval(XMLFile file, String query) {
        super(file);
        this.query = query;
    }

    @Override
    public Document replace() throws Exception {
        return (Document)this.in.inContext(doc -> (Document)this.in.nodeQuery(this.query).flatMapThrowing(node -> {
            Node parent = node.getParentNode();
            if (parent != null) {
                Node sib = node.getNextSibling();
                if (sib instanceof Text && sib.getTextContent().trim().isEmpty()) {
                    parent.removeChild(sib);
                }
                parent.removeChild((Node)node);
                return ThrowingOptional.of((Object)doc);
            }
            return ThrowingOptional.empty();
        }).orElse(null));
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + Objects.hashCode(this.in);
        hash = 29 * hash + Objects.hashCode(this.query);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != XMLElementRemoval.class) {
            return false;
        }
        XMLElementRemoval other = (XMLElementRemoval)obj;
        if (!Objects.equals(this.query, other.query)) {
            return false;
        }
        return Objects.equals(this.in, other.in);
    }

    public String toString() {
        return this.query + " REMOVAL in " + this.in;
    }
}

