/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.maven.xml;

import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.maven.xml.AbstractXMLUpdater;
import com.telenav.cactus.maven.xml.XMLFile;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class XMLTextContentReplacement
extends AbstractXMLUpdater {
    private final String xslQuery;
    private final String newValue;

    public XMLTextContentReplacement(XMLFile in, String xslQuery, String newValue) {
        super(in);
        this.xslQuery = (String)Checks.notNull((String)"xslQuery", (Object)xslQuery);
        this.newValue = newValue;
    }

    public String toString() {
        return this.xslQuery + " -> " + this.newValue + " in " + this.in.path();
    }

    @Override
    public Document replace() throws Exception {
        return (Document)this.in.inContext(doc -> (Document)this.in.nodeQuery(this.xslQuery).map(node -> {
            boolean result;
            boolean bl = result = !Objects.equals(this.newValue, node.getTextContent().trim());
            if (result) {
                if (this.newValue == null) {
                    Element nue = doc.createElement(node.getNodeName());
                    node.getParentNode().replaceChild(nue, (Node)node);
                } else {
                    node.setTextContent(this.newValue);
                }
            }
            return doc;
        }).orElse(null));
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + Objects.hashCode(this.in);
        hash = 29 * hash + Objects.hashCode(this.xslQuery);
        hash = 29 * hash + Objects.hashCode(this.newValue);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != XMLTextContentReplacement.class) {
            return false;
        }
        XMLTextContentReplacement other = (XMLTextContentReplacement)obj;
        if (!Objects.equals(this.xslQuery, other.xslQuery)) {
            return false;
        }
        if (!Objects.equals(this.newValue, other.newValue)) {
            return false;
        }
        return Objects.equals(this.in, other.in);
    }
}

