/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.metadata;

import com.telenav.cactus.metadata.BuildName;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class BuildMetadata {
    public static final String KEY_BUILD_NAME = "build-name";
    public static final String KEY_BUILD_DATE = "build-date";
    public static final String KEY_BUILD_NUMBER = "build-number";
    public static final String KEY_GIT_COMMIT_TIMESTAMP = "commit-timestamp";
    public static final String KEY_GIT_COMMIT_HASH = "commit-long-hash";
    public static final String KEY_GIT_REPO_CLEAN = "no-local-modifications";
    private static final Map<Class<?>, BuildMetadata> projectToMetadata = new ConcurrentHashMap();
    private final Class<?> projectType;
    private final Type type;
    Map<String, String> buildProperties;
    private Map<String, String> projectProperties;
    private final Map<String, String> additionalProperties;

    public static BuildMetadata buildMetaData(Class<?> projectType) {
        return projectToMetadata.computeIfAbsent(projectType, ignored -> new BuildMetadata(projectType, Type.PROJECT, Collections.emptyMap()));
    }

    static Map<String, String> properties(String text) {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        try {
            Pattern pattern = Pattern.compile("(?x) (?<key> [\\w-]+?) \\s* = \\s* (?<value> .*)");
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                properties.put(matcher.group("key"), matcher.group("value"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    static LocalDate todaysLocalDate() {
        return LocalDateTime.now().atZone(ZoneId.of(ZoneOffset.UTC.getId())).toLocalDate();
    }

    BuildMetadata(Class<?> projectType, Type type, Map<String, String> additionalProperties) {
        this.projectType = projectType;
        this.type = type;
        this.additionalProperties = additionalProperties;
    }

    public Map<String, String> buildProperties() {
        if (this.buildProperties == null) {
            if (this.type == Type.CURRENT) {
                TreeMap<String, String> properties = new TreeMap<String, String>();
                properties.put(KEY_BUILD_NUMBER, Integer.toString(this.currentBuildNumber()));
                properties.put(KEY_BUILD_DATE, DateTimeFormatter.ofPattern("yyyy.MM.dd").format(this.currentBuildDate()));
                properties.put(KEY_BUILD_NAME, BuildName.name(this.currentBuildNumber()));
                properties.putAll(this.additionalProperties);
                this.buildProperties = properties;
            } else {
                this.buildProperties = BuildMetadata.properties(BuildMetadata.metadata(this.projectType, "/build.properties"));
                this.buildProperties.putAll(this.additionalProperties);
            }
        }
        return this.buildProperties;
    }

    public int currentBuildNumber() {
        return BuildName.toBuildNumber(this.currentBuildDate());
    }

    public Optional<String> gitCommitHash() {
        return Optional.ofNullable(this.buildProperties().get(KEY_GIT_COMMIT_HASH));
    }

    public Optional<ZonedDateTime> gitCommitTimestamp() {
        Map<String, String> map = this.buildProperties == null ? this.additionalProperties : this.buildProperties;
        return Optional.ofNullable(map.get(KEY_GIT_COMMIT_TIMESTAMP)).map(dateString -> ZonedDateTime.parse(dateString, DateTimeFormatter.ISO_DATE_TIME));
    }

    public boolean isCleanRepository() {
        Map<String, String> map = this.buildProperties == null ? this.additionalProperties : this.buildProperties;
        return "true".equals(map.get(KEY_GIT_REPO_CLEAN));
    }

    public synchronized Map<String, String> projectProperties() {
        if (this.projectProperties == null || this.projectProperties.isEmpty()) {
            this.projectProperties = BuildMetadata.properties(BuildMetadata.metadata(this.projectType, "/project.properties"));
        }
        return this.projectProperties;
    }

    public Optional<String> shortGitCommitHash() {
        return this.gitCommitHash().map(hash -> hash.substring(0, 7));
    }

    private static String metadata(Class<?> project, String path) {
        try {
            InputStream input = project.getResourceAsStream(path);
            if (input != null) {
                return new BufferedReader(new InputStreamReader(input)).lines().collect(Collectors.joining("\n")).trim();
            }
            throw new IllegalStateException("No metadata found relative to " + project.getName() + " at " + path + " using classloader " + project.getClassLoader() + " (" + project.getClassLoader().getClass().getName() + ")");
        }
        catch (Exception cause) {
            throw new IllegalStateException("Unable to read: " + path, cause);
        }
    }

    LocalDate currentBuildDate() {
        return this.gitCommitTimestamp().filter(zdt -> this.isCleanRepository()).map(ZonedDateTime::toLocalDate).orElse(BuildMetadata.todaysLocalDate());
    }

    public static enum Type {
        PROJECT,
        CURRENT;

    }
}

