/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.metadata;

import com.telenav.cactus.metadata.BuildMetadata;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class BuildMetadataUpdater {
    public static void main(String[] arguments) {
        block11: {
            if (arguments.length >= 1) {
                try {
                    Path outputPath = Path.of(arguments[0], new String[0]);
                    if (!Files.isDirectory(outputPath, new LinkOption[0])) {
                        Files.createDirectory(outputPath, new FileAttribute[0]);
                    }
                    Map<String, String> additionalArguments = BuildMetadataUpdater.collectAdditionalArguments(arguments);
                    Map<String, String> properties = new BuildMetadata(null, BuildMetadata.Type.CURRENT, additionalArguments).buildProperties();
                    ArrayList<CallSite> lines = new ArrayList<CallSite>();
                    for (String key : properties.keySet()) {
                        lines.add((CallSite)((Object)(key + " = " + properties.get(key))));
                    }
                    try (PrintStream out = new PrintStream(outputPath.resolve("build.properties").toFile());){
                        out.println(String.join((CharSequence)"\n", lines));
                        break block11;
                    }
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception cause) {
                    throw new IllegalStateException("Unable to write metadata: " + Arrays.toString(arguments), cause);
                }
            }
            System.err.println("Usage: kivakit-metadata [output-folder] ([key] [value])*");
        }
    }

    private static Map<String, String> collectAdditionalArguments(String[] arguments) {
        if (arguments.length > 1) {
            if (arguments.length % 2 == 0) {
                throw new IllegalArgumentException("Following key/value pairs must be balanced, but " + (arguments.length - 1) + " passed: " + Arrays.toString(Arrays.copyOfRange(arguments, 1, arguments.length)));
            }
            TreeMap<String, String> additionalArguments = new TreeMap<String, String>();
            for (int i = 1; i < arguments.length; i += 2) {
                block6 : switch (arguments[i]) {
                    case "commit-timestamp": {
                        try {
                            ZonedDateTime.parse(arguments[i + 1], DateTimeFormatter.ISO_DATE_TIME);
                            break;
                        }
                        catch (DateTimeParseException ex) {
                            throw new IllegalArgumentException(arguments[i] + " must be in ISO 8601 instant format, but got " + arguments[i + 1]);
                        }
                    }
                    case "no-local-modifications": {
                        switch (arguments[i + 1]) {
                            case "true": 
                            case "false": {
                                break block6;
                            }
                        }
                        throw new IllegalArgumentException(arguments[i] + " must be either 'true' or 'false' but got '" + arguments[i + 1]);
                    }
                    case "commit-long-hash": {
                        for (int j = 0; j < arguments[i + 1].length(); ++j) {
                            char c = arguments[i + 1].charAt(j);
                            if (c >= 'a' && c <= 'f' || c >= '0' && c <= '9') continue;
                            throw new IllegalArgumentException("Valid characters in a git  hash are 0-9 a-f");
                        }
                        break;
                    }
                }
                additionalArguments.put(arguments[i], arguments[i + 1]);
            }
            return additionalArguments;
        }
        return Collections.emptyMap();
    }
}

