/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.metadata;

import java.time.LocalDate;
import java.time.ZonedDateTime;

public class BuildName {
    public static final int TELENAV_EPOCH_DAY = 18601;
    private static final String[] nouns = new String[]{"monkey", "gorilla", "tornado", "rhino", "rabbit", "dog", "turtle", "goat", "dinosaur", "shark", "snake", "bunny", "marmot", "star", "alpaca", "panda", "hamster", "hedgehog", "kangaroo", "crocodile", "duckling", "hippo", "dolphin", "owl", "seal", "piglet", "penguin", "truck", "sneakers", "dracula", "trebuchet", "chameleon", "lizard", "donkey", "koala", "otter", "cat", "wombat", "beachball", "capybara", "buffalo", "frog", "mouse", "telephone", "laptop", "toaster", "waffle", "bobblehead", "crayon", "sunglasses", "light-bulb", "water-wings", "shoes", "bongos", "goldfish", "legos", "tulips", "dune-buggy", "torpedo", "rocket", "diorama", "beanbag", "radio", "banana"};
    private static final String[] adjectives = new String[]{"blue", "sparkling", "orange", "puffy", "beryllium", "plutonium", "mango", "cobalt", "purple", "tungsten", "yellow", "happy", "transparent", "pink", "aqua", "lavender", "alabaster", "laughing", "lemon", "tangerine", "golden", "silver", "bronze", "amber", "ruby", "goldenrod", "khaki", "violet", "lime", "steel", "red", "ceramic", "platinum", "carbon", "navy", "stretchy", "nickel", "copper", "funky", "aluminum", "zinc", "chrome", "lead", "radium", "zinc", "iron", "charcoal", "titanium", "angry", "chocolate", "turquoise", "cerulean", "apricot", "green", "maroon", "blas\u00e9", "grumpy", "cornflower", "chartreuse", "neon", "mustard", "rubber", "paper", "plastic"};

    public static int toBuildNumber(LocalDate date) {
        return (int)(date.toEpochDay() - 18601L);
    }

    public static String name(ZonedDateTime when) {
        return BuildName.name(when.toLocalDate());
    }

    public static String name(LocalDate when) {
        return BuildName.name(BuildName.toBuildNumber(when));
    }

    public static String name(int buildNumber) {
        String noun = nouns[buildNumber % nouns.length];
        String adjective = adjectives[buildNumber / nouns.length % adjectives.length];
        return adjective + " " + noun;
    }
}

