/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.process;

import com.telenav.cactus.process.ProcessControl;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

final class KillQueue {
    private static final KillQueue INSTANCE = new KillQueue();
    private final DelayQueue<KillQueueEntry> toKill = new DelayQueue();
    private final AtomicBoolean started = new AtomicBoolean();
    static Consumer<ProcessControl<?, ?>> VERIFIER = ignored -> {};

    private KillQueue() {
    }

    static void enqueue(Duration after, ProcessControl<?, ?> ctrl) {
        INSTANCE._enqueue(after, ctrl);
    }

    static boolean isStarted() {
        return KillQueue.INSTANCE.started.get();
    }

    private void _enqueue(Duration after, ProcessControl<?, ?> ctrl) {
        long expires = System.currentTimeMillis() + after.toMillis();
        this.toKill.offer(new KillQueueEntry(ctrl, expires));
        if (this.started.compareAndSet(false, true)) {
            Thread killThread = new Thread(this::killLoop, "Process timeout killer");
            killThread.setPriority(4);
            killThread.setDaemon(true);
            killThread.start();
        }
    }

    private void killLoop() {
        try {
            while (true) {
                try {
                    while (true) {
                        ((KillQueueEntry)this.toKill.take()).kill();
                    }
                }
                catch (Error | Exception ex) {
                    if (ex instanceof InterruptedException) continue;
                    if (ex instanceof ThreadDeath) {
                        throw (ThreadDeath)ex;
                    }
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            this.started.set(false);
            throw throwable;
        }
    }

    private final class KillQueueEntry
    implements Delayed {
        private final Reference<ProcessControl<?, ?>> processRef;
        private final long expiresAt;

        public KillQueueEntry(ProcessControl<?, ?> process, long expiresAt) {
            this.processRef = new WeakReference(process);
            this.expiresAt = expiresAt;
        }

        boolean isDead() {
            return this.processRef.get() == null;
        }

        boolean kill() {
            ProcessControl<?, ?> process = this.processRef.get();
            if (process != null) {
                VERIFIER.accept(process);
                return process.kill();
            }
            return false;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            if (this.isDead()) {
                return 0L;
            }
            return unit.convert(Math.max(0L, this.expiresAt - System.currentTimeMillis()), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), o.getDelay(TimeUnit.MILLISECONDS));
        }
    }
}

