/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.process;

import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.process.AbortOnInputStdinHandler;
import com.telenav.cactus.process.FailedProcessControl;
import com.telenav.cactus.process.KillQueue;
import com.telenav.cactus.process.OutputHandler;
import com.telenav.cactus.process.ProcessResult;
import com.telenav.cactus.process.ProcessState;
import com.telenav.cactus.process.StandardInputHandler;
import com.telenav.cactus.process.internal.ProcessCallback;
import com.zaxxer.nuprocess.NuProcessBuilder;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public interface ProcessControl<O, E> {
    public void onExit(CompletableFuture<ProcessResult<O, E>> var1);

    public ProcessState state();

    default public ProcessControl<O, E> killAfter(Duration maximumRunTime) {
        KillQueue.enqueue(maximumRunTime, this);
        return this;
    }

    default public int processIdentifier() {
        return -1;
    }

    public static <O, E> ProcessControl<O, E> failure(Exception thrown) {
        return new FailedProcessControl(thrown);
    }

    default public CompletionStage<ProcessResult<O, E>> onExit() {
        CompletableFuture<ProcessResult<O, E>> result = new CompletableFuture<ProcessResult<O, E>>();
        this.onExit(result);
        return result;
    }

    public static ProcessControl<String, String> create(NuProcessBuilder bldr) {
        Checks.notNull((String)"bldr", (Object)bldr);
        ProcessCallback<String, String> result = ProcessCallback.create();
        Checks.notNull((String)"result", result);
        bldr.setProcessListener(result);
        return result;
    }

    default public ProcessControl<O, E> abortOnInput() {
        return this.withStandardInputHandler(new AbortOnInputStdinHandler(), true);
    }

    default public ProcessControl<O, E> abortOnInput(Runnable notificationCallback) {
        return this.withStandardInputHandler(new AbortOnInputStdinHandler(notificationCallback), true);
    }

    public <T> ProcessControl<T, E> withOutputHandler(OutputHandler<T> var1);

    public <T> ProcessControl<O, T> withErrorHandler(OutputHandler<T> var1);

    default public ProcessControl<Void, Void> ignoringOutput() {
        return this.withOutputHandler(OutputHandler.NULL).withErrorHandler(OutputHandler.NULL);
    }

    public void await() throws InterruptedException;

    public void await(Duration var1) throws InterruptedException;

    public boolean isRunning();

    public boolean kill();

    public ProcessResult<O, E> result();

    public ProcessControl<O, E> withStandardInputHandler(StandardInputHandler var1, boolean var2);

    public int exitValue();
}

