/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.process;

import com.telenav.cactus.process.ProcessResultImpl;
import com.telenav.cactus.process.ProcessState;

public abstract class ProcessResult<O, E> {
    ProcessResult() {
    }

    public static <O, E> ProcessResult<O, E> create(ProcessState state, O stdout, E stderr) {
        return new ProcessResultImpl<O, E>(state, stdout, stderr);
    }

    public abstract ProcessState state();

    public abstract O standardOutput();

    public abstract E standardError();

    public final boolean isSuccess() {
        return !this.wasKilled() && this.state().isExited() && this.state().exitCode() == 0;
    }

    public final boolean hasExited() {
        return this.state().isExited();
    }

    public final boolean wasKilled() {
        return this.state().wasKilled();
    }

    public final String toString() {
        return this.state() + "\n" + this.standardOutput() + "\n" + this.standardError();
    }

    public final int exitValue() {
        return this.state().effectiveExitCode();
    }
}

