/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.process;

public final class ProcessState {
    private static final int STATE_MASK = 3;
    private final int value;
    private static final RunningStatus[] STATII = RunningStatus.values();
    public static final ProcessState INITIAL = new ProcessState();

    private ProcessState(int value) {
        this.value = value;
    }

    public static ProcessState processState(int value) {
        switch (value) {
            case 0: {
                return INITIAL;
            }
        }
        int stateOrdinal = value & 3;
        if (stateOrdinal >= STATII.length) {
            throw new IllegalArgumentException("State ordinal out of range: " + stateOrdinal);
        }
        return new ProcessState(value);
    }

    ProcessState() {
        this(0);
    }

    public int exitCode() {
        return this.value >> 16;
    }

    public int effectiveExitCode() {
        if (this.wasKilled()) {
            return Integer.MAX_VALUE;
        }
        if (this.isBeforeStart() || this.isRunning()) {
            return -1;
        }
        return this.exitCode();
    }

    public ProcessState withExitCode(int code) {
        if (Integer.MIN_VALUE == code) {
            code = Short.MAX_VALUE;
        }
        if (code < 0 || code > 32768) {
            throw new IllegalArgumentException("Exit code out of range: " + code);
        }
        int masked = this.value & 0xFF;
        int newValue = masked | RunningStatus.EXITED.ordinal() | code << 16;
        return new ProcessState(newValue);
    }

    public ProcessState wantingInput() {
        if (this.wantsInput()) {
            return this;
        }
        return new ProcessState(this.value | 8);
    }

    public ProcessState notWantingInput() {
        if (!this.wantsInput()) {
            return this;
        }
        return new ProcessState(this.value & 0xFFFFFFF7);
    }

    public boolean wantsInput() {
        return (this.value & 8) != 0;
    }

    public ProcessState killed() {
        return (this.value & 4) == 0 ? new ProcessState(this.value | 4) : this;
    }

    public boolean wasKilled() {
        return (this.value & 4) != 0;
    }

    public RunningStatus state() {
        return STATII[this.value & 3];
    }

    public ProcessState toState(RunningStatus nue) {
        if (this.state() == nue) {
            return this;
        }
        int mask = -4;
        int newValue = this.value & mask | nue.ordinal();
        return this.value == newValue ? this : new ProcessState(newValue);
    }

    public int intValue() {
        return this.value;
    }

    public boolean isRunning() {
        return this.state().isRunning();
    }

    public boolean isExited() {
        return this.state().isExited();
    }

    public String toString() {
        int code = this.exitCode();
        return this.state() + (this.wantsInput() ? " input" : "") + (this.wasKilled() ? " killed" : "") + " " + code + " (" + Integer.toHexString(this.value) + ")";
    }

    public boolean isBeforeStart() {
        return this.state().isBeforeStart();
    }

    public boolean equals(Object o) {
        return o != null && ProcessState.class == o.getClass() && ((ProcessState)o).intValue() == this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public static enum RunningStatus {
        UNINITIALIZED,
        STARTING,
        RUNNING,
        EXITED;


        public String toString() {
            return this.name().toLowerCase().replace('_', '-');
        }

        public boolean isBeforeStart() {
            return this == UNINITIALIZED || this == STARTING;
        }

        public boolean isRunning() {
            return this == RUNNING;
        }

        public boolean isExited() {
            return this == EXITED;
        }

        public boolean isStarted() {
            return this.isRunning() || this.isExited();
        }
    }
}

