/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.process;

import com.telenav.cactus.process.OutputHandler;
import com.telenav.cactus.process.ProcessControl;
import java.nio.ByteBuffer;
import java.util.Optional;

public interface StringOutputHandler
extends OutputHandler<String> {
    default public OutputHandler<Optional<String>> ifNonEmpty() {
        return new OutputHandler<Optional<String>>(){

            @Override
            public void onOutput(ProcessControl<?, ?> process, ByteBuffer output, boolean closed) {
                StringOutputHandler.this.onOutput(process, output, closed);
            }

            @Override
            public Optional<String> result() {
                String res = (String)StringOutputHandler.this.result();
                return res == null || res.isBlank() ? Optional.empty() : Optional.of(res.trim());
            }
        };
    }

    default public OutputHandler<Optional<String>> optional() {
        return new OutputHandler<Optional<String>>(){

            @Override
            public void onOutput(ProcessControl<?, ?> process, ByteBuffer output, boolean closed) {
                StringOutputHandler.this.onOutput(process, output, closed);
            }

            @Override
            public Optional<String> result() {
                return Optional.ofNullable((String)StringOutputHandler.this.result());
            }
        };
    }

    default public StringOutputHandler trimmed() {
        return new StringOutputHandler(){

            @Override
            public void onOutput(ProcessControl<?, ?> process, ByteBuffer output, boolean closed) {
                StringOutputHandler.this.onOutput(process, output, closed);
            }

            @Override
            public String result() {
                String originalResult = (String)StringOutputHandler.this.result();
                return originalResult == null ? null : originalResult.trim();
            }
        };
    }
}

