/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.process.internal;

import com.mastfrog.concurrent.ConcurrentLinkedList;
import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.process.OutputHandler;
import com.telenav.cactus.process.ProcessControl;
import com.telenav.cactus.process.ProcessResult;
import com.telenav.cactus.process.ProcessState;
import com.telenav.cactus.process.StandardInputHandler;
import com.telenav.cactus.process.internal.ProcessListener;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessHandler;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;

public final class ProcessCallback<O, E>
implements NuProcessHandler,
ProcessControl<O, E> {
    private final AtomicInteger state;
    private final CountDownLatch latch;
    private final ConcurrentLinkedList<ProcessListener> listeners;
    private final OutputHandler<O> stdout;
    private final OutputHandler<E> stderr;
    private volatile int pid = -1;
    private StandardInputHandler stdin = StandardInputHandler.DEFAULT;
    private NuProcess process;

    ProcessCallback(OutputHandler<O> stdout, OutputHandler<E> stderr) {
        this.stdout = stdout;
        this.stderr = stderr;
        this.state = new AtomicInteger();
        this.latch = new CountDownLatch(1);
        this.listeners = ConcurrentLinkedList.fifo();
    }

    <OO, EE> ProcessCallback(ProcessCallback<OO, EE> orig, OutputHandler<O> stdout, OutputHandler<E> stderr) {
        this.stdout = stdout;
        this.stderr = stderr;
        this.state = orig.state;
        this.latch = orig.latch;
        this.listeners = orig.listeners;
        this.stdin = orig.stdin;
        this.process = orig.process;
    }

    @Override
    public <T> ProcessControl<O, T> withErrorHandler(OutputHandler<T> oe) {
        ProcessState.RunningStatus runState = this.state().state();
        switch (runState) {
            case UNINITIALIZED: {
                break;
            }
            default: {
                throw new IllegalStateException("Cannot replace error handler in state " + runState);
            }
        }
        return new ProcessCallback<O, T>(this, this.stdout, oe);
    }

    @Override
    public <T> ProcessControl<T, E> withOutputHandler(OutputHandler<T> oh) {
        ProcessState.RunningStatus runState = this.state().state();
        switch (runState) {
            case UNINITIALIZED: {
                break;
            }
            default: {
                throw new IllegalStateException("Cannot replace error handler in state " + runState);
            }
        }
        return new ProcessCallback<T, E>(this, oh, this.stderr);
    }

    public static <O, E> ProcessCallback<O, E> create(OutputHandler<O> output, OutputHandler<E> error) {
        return new ProcessCallback<O, E>(output, error);
    }

    public static <O> ProcessCallback<O, Void> create(OutputHandler<O> output) {
        return new ProcessCallback<O, Void>(output, OutputHandler.NULL);
    }

    public static ProcessCallback<String, String> create() {
        return new ProcessCallback<String, String>(OutputHandler.string(), OutputHandler.string());
    }

    private ProcessState updateAndGetState(UnaryOperator<ProcessState> transition) {
        int result = this.state.updateAndGet(old -> ((ProcessState)transition.apply(ProcessState.processState(old))).intValue());
        return ProcessState.processState(result);
    }

    private ProcessState getAndUpdateState(UnaryOperator<ProcessState> transition) {
        int result = this.state.getAndUpdate(old -> ((ProcessState)transition.apply(ProcessState.processState(old))).intValue());
        return ProcessState.processState(result);
    }

    @Override
    public ProcessState state() {
        return ProcessState.processState(this.state.get());
    }

    @Override
    public synchronized int processIdentifier() {
        return this.pid;
    }

    @Override
    public synchronized ProcessCallback<O, E> withStandardInputHandler(StandardInputHandler handler, boolean wantIn) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot set StandardInputHandler after process launch");
        }
        this.stdin = (StandardInputHandler)Checks.notNull((String)"handler", (Object)handler);
        ProcessState prev = this.getAndUpdateState(old -> old.wantingInput());
        if (this.process != null && !prev.wantsInput()) {
            this.process.wantWrite();
        }
        return this;
    }

    @Override
    public int exitValue() {
        return this.state().exitCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean kill() {
        NuProcess proc;
        ProcessCallback processCallback = this;
        synchronized (processCallback) {
            proc = this.process;
        }
        if (proc == null) {
            return false;
        }
        if (proc.isRunning()) {
            try {
                proc.destroy(true);
                boolean bl = true;
                return bl;
            }
            finally {
                this.getAndUpdateState(old -> old.killed());
            }
        }
        return false;
    }

    @Override
    public boolean isRunning() {
        return this.state().isRunning();
    }

    public synchronized StandardInputHandler stdin() {
        return this.stdin;
    }

    @Override
    public void onExit(CompletableFuture<ProcessResult<O, E>> future) {
        this.listen(exitCode -> future.complete(this.result()));
    }

    public void listen(ProcessListener l) {
        int code;
        this.listeners.push((Object)l);
        ProcessState state = this.state();
        int n = state.wasKilled() ? Integer.MAX_VALUE : (code = state.isExited() ? state.exitCode() : -1);
        if (code >= 0) {
            this.notifyListeners(code);
        }
    }

    @Override
    public void await() throws InterruptedException {
        this.latch.await();
    }

    @Override
    public void await(Duration dur) throws InterruptedException {
        this.latch.await(dur.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void notifyListeners(int exitCode) {
        ProcessState state = this.state().withExitCode(exitCode);
        try {
            this.listeners.drain(listener -> listener.processExited(state));
        }
        finally {
            this.latch.countDown();
        }
    }

    public void onExit(int exit) {
        ProcessState old = this.getAndUpdateState(oldState -> oldState.withExitCode(exit));
        if (old.exitCode() == 0 && old.isRunning()) {
            this.notifyListeners(exit);
            this.latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPreStart(NuProcess np) {
        ProcessCallback processCallback = this;
        synchronized (processCallback) {
            this.process = (NuProcess)Checks.notNull((String)"np", (Object)np);
        }
        this.updateAndGetState(old -> old.toState(ProcessState.RunningStatus.STARTING));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart(NuProcess np) {
        boolean wantWrite;
        ProcessCallback processCallback = this;
        synchronized (processCallback) {
            this.process = (NuProcess)Checks.notNull((String)"np", (Object)np);
            this.pid = np.getPID();
        }
        if (this.state().wasKilled()) {
            np.destroy(true);
        }
        if (wantWrite = this.updateAndGetState(old -> old.toState(ProcessState.RunningStatus.RUNNING)).wantsInput()) {
            np.wantWrite();
        }
    }

    public void onStdout(ByteBuffer bb, boolean bln) {
        this.stdout.onOutput(this, bb, bln);
    }

    public void onStderr(ByteBuffer bb, boolean bln) {
        this.stderr.onOutput(this, bb, bln);
    }

    public boolean onStdinReady(ByteBuffer bb) {
        return this.stdin().onStdinReady(this, bb);
    }

    @Override
    public ProcessResult<O, E> result() {
        return ProcessResult.create(this.state(), this.stdout.result(), this.stderr.result());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        NuProcess proc;
        ProcessCallback processCallback = this;
        synchronized (processCallback) {
            proc = this.process;
        }
        return this.pid + " " + proc + " " + this.state();
    }
}

