/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.scope;

import com.mastfrog.function.optional.ThrowingOptional;
import com.mastfrog.function.throwing.ThrowingRunnable;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.LevenshteinDistance;
import com.telenav.cactus.maven.model.GroupId;
import com.telenav.cactus.maven.model.MavenArtifactCoordinates;
import com.telenav.cactus.maven.model.MavenIdentified;
import com.telenav.cactus.maven.model.PomVersion;
import com.telenav.cactus.util.PathUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ProjectFamily
implements Comparable<ProjectFamily> {
    public static final String ASSETS_HOME_SUFFIX = "_ASSETS_HOME";
    public static final String ASSETS_CHECKOUT_SUFFIX = "-assets";
    private final String name;

    public static ProjectFamily familyOf(GroupId groupId) {
        return ProjectFamily.fromGroupId(groupId.text());
    }

    public static ProjectFamily familyOf(MavenIdentified artifact) {
        return ProjectFamily.familyOf(artifact.groupId());
    }

    public static ProjectFamily fromGroupId(String groupId) {
        if (((String)Checks.notNull((String)"groupId", (Object)groupId)).indexOf(46) < 0) {
            return ProjectFamily.named(groupId);
        }
        int lastDot = groupId.lastIndexOf(46);
        if (lastDot == groupId.length() - 1) {
            throw new IllegalArgumentException("Trailing . not allowed: '" + groupId + "'");
        }
        String tail = groupId.substring(lastDot + 1);
        int dashIndex = tail.indexOf(45);
        if (dashIndex == 0 || dashIndex == tail.length() - 1) {
            throw new IllegalArgumentException("Leading and trailing - not allowed: '" + tail + "'");
        }
        if (dashIndex > 0) {
            tail = tail.substring(0, dashIndex);
        }
        return new ProjectFamily(tail);
    }

    public static Set<ProjectFamily> fromCommaDelimited(String what, Supplier<ProjectFamily> fallback) {
        ProjectFamily fam;
        if (what != null && !what.isBlank()) {
            LinkedHashSet<ProjectFamily> result = new LinkedHashSet<ProjectFamily>();
            for (String part : what.split(",")) {
                if ((part = part.trim()).isEmpty()) continue;
                result.add(ProjectFamily.named(part));
            }
            if (!result.isEmpty()) {
                return result;
            }
        }
        if ((fam = fallback.get()) != null) {
            return Collections.singleton(fam);
        }
        return Collections.emptySet();
    }

    public static ProjectFamily named(String name) {
        return new ProjectFamily((String)Checks.notNull((String)"name", (Object)name));
    }

    private ProjectFamily(String name) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Empty family name");
        }
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Family may not contain dots: '" + name + "'");
        }
        this.name = name;
    }

    public String assetsEnvironmentVariable() {
        return this.name.toUpperCase() + ASSETS_HOME_SUFFIX;
    }

    public ThrowingOptional<Path> assetsPath(ThrowingOptional<Path> submoduleRoot) {
        ThrowingOptional result;
        String envVar = System.getenv(this.assetsEnvironmentVariable());
        if (envVar == null) {
            envVar = System.getProperty(this.assetsEnvironmentVariable());
        }
        Path path = null;
        if (envVar != null && (result = ThrowingOptional.from((Optional)PathUtils.ifDirectory((Path)(path = Paths.get(envVar, new String[0]))))).isPresent()) {
            return result;
        }
        return submoduleRoot.flatMap(root -> PathUtils.ifDirectory((Path)root.resolve(this.name + ASSETS_CHECKOUT_SUFFIX)));
    }

    @Override
    public int compareTo(ProjectFamily o) {
        return this.name.compareToIgnoreCase(o.name);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != ProjectFamily.class) {
            return false;
        }
        return ((ProjectFamily)o).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode() * 71;
    }

    public boolean ifMember(MavenIdentified prj, ThrowingRunnable run) {
        if (this.is(prj)) {
            ((ThrowingRunnable)Checks.notNull((String)"run", (Object)run)).toNonThrowing().run();
            return true;
        }
        return false;
    }

    public boolean ifMemberOrParent(MavenIdentified prj, ThrowingRunnable code) {
        boolean result = this.ifMember(prj, code);
        if (!result) {
            result = this.ifParentFamily(prj, code);
        }
        return result;
    }

    public boolean ifParentFamily(MavenIdentified prj, ThrowingRunnable code) {
        if (this.isParentFamilyOf(prj)) {
            code.toNonThrowing().run();
            return true;
        }
        return false;
    }

    public boolean is(MavenIdentified prj) {
        return ProjectFamily.familyOf(prj).equals(this);
    }

    public boolean is(String what) {
        return what != null && !what.isEmpty() && this.name.equals(what.trim());
    }

    public boolean isParentFamilyOf(MavenIdentified prj) {
        return this.isParentFamilyOf(((MavenIdentified)Checks.notNull((String)"prj", (Object)prj)).groupId());
    }

    public boolean isParentFamilyOf(GroupId groupId) {
        return this.isParentFamilyOf(groupId.text());
    }

    public void ifParentFamilyOf(GroupId groupId, Runnable run) {
        if (this.isParentFamilyOf(groupId)) {
            run.run();
        }
    }

    public boolean isParentFamilyOf(String gid) {
        int ix = ((String)Checks.notNull((String)"gid", (Object)gid)).lastIndexOf(46);
        if (ix > 0) {
            gid = gid.substring(0, ix);
        }
        return ProjectFamily.fromGroupId(gid).equals(this);
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public Optional<PomVersion> probableFamilyVersion(Collection<? extends MavenArtifactCoordinates> coords) {
        List filtered = coords.stream().filter(this::is).collect(Collectors.toCollection(ArrayList::new));
        Comparator nameDistance = LevenshteinDistance.distanceComparator((String)this.name());
        Comparator c = (a, b) -> nameDistance.compare(a.artifactId().text(), b.artifactId().text());
        return PomVersion.mostCommonVersion((Collection)filtered, (Comparator)c);
    }
}

