/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.scope;

import com.telenav.cactus.util.EnumMatcher;
import java.util.Arrays;
import java.util.Optional;

public enum Scope {
    JUST_THIS,
    FAMILY,
    FAMILY_OR_CHILD_FAMILY,
    SAME_GROUP_ID,
    ALL_PROJECT_FAMILIES,
    ALL;


    public String toString() {
        return this.name().toLowerCase().replace('_', '-');
    }

    public boolean canBeMultiFamily() {
        switch (this) {
            case ALL: 
            case ALL_PROJECT_FAMILIES: {
                return true;
            }
        }
        return false;
    }

    public static Scope find(String prop) {
        if (prop == null) {
            return FAMILY;
        }
        Optional result = EnumMatcher.enumMatcher(Scope.class).match(prop);
        if (result.isEmpty()) {
            String msg = "Unknown scope " + prop + " is not one of " + Arrays.toString((Object[])Scope.values());
            throw new IllegalStateException(msg);
        }
        return (Scope)((Object)result.get());
    }

    public boolean appliesFamily() {
        return this == FAMILY || this == FAMILY_OR_CHILD_FAMILY;
    }
}

