/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.tasks;

import com.mastfrog.function.throwing.ThrowingRunnable;
import com.mastfrog.function.throwing.ThrowingSupplier;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;

public final class Rollback {
    private final ThrowingRunnable rollback = ThrowingRunnable.oneShot((boolean)true);

    public void rollback() throws Exception {
        this.rollback.run();
    }

    public <T extends ThrowingRunnable> T executeWithRollback(T code) {
        try {
            code.run();
        }
        catch (Error | Exception failure) {
            try {
                this.rollback.run();
            }
            catch (Error | Exception rollbackFailure) {
                failure.addSuppressed(rollbackFailure);
            }
            return (T)((ThrowingRunnable)Exceptions.chuck((Throwable)failure));
        }
        return code;
    }

    public <T> T executeWithRollback(ThrowingSupplier<? extends T> code) {
        try {
            return (T)code.get();
        }
        catch (Error | Exception failure) {
            try {
                this.rollback.run();
            }
            catch (Error | Exception rollbackFailure) {
                failure.addSuppressed(rollbackFailure);
            }
            return (T)Exceptions.chuck((Throwable)failure);
        }
    }

    public Rollback addRollbackTask(ThrowingRunnable run) {
        this.rollback.andAlways((ThrowingRunnable)Checks.notNull((String)"run", (Object)run));
        return this;
    }
}

