/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.tasks;

import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.tasks.Rollback;
import com.telenav.cactus.tasks.Task;
import com.telenav.cactus.tasks.TaskGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

final class TaskGroupImpl
implements TaskGroup {
    private final List<Task> children = new CopyOnWriteArrayList<Task>();
    final String name;

    TaskGroupImpl(String name) {
        this.name = (String)Checks.notNull((String)"name", (Object)name);
    }

    @Override
    public Iterator<Task> iterator() {
        return Collections.unmodifiableList(this.children).iterator();
    }

    @Override
    public boolean isEmpty() {
        boolean result = this.children.isEmpty();
        if (!result) {
            result = true;
            for (Task t : this.children) {
                if (t.isEmpty()) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    public TaskGroup add(Task task) {
        this.children.add(task);
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(Consumer<String> log, Rollback rollbacks) throws Exception {
        log.accept(this.name());
        Set executed = Collections.newSetFromMap(new IdentityHashMap());
        while (!this.children.isEmpty()) {
            try {
                ArrayList<Task> copy = new ArrayList<Task>(this.children);
                for (Task child : copy) {
                    child.accept(log, rollbacks);
                    executed.add(child);
                }
            }
            finally {
                this.children.removeAll(executed);
                executed.clear();
            }
        }
    }

    public String toString() {
        return this.stringify();
    }
}

