/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.tasks;

import com.mastfrog.function.throwing.ThrowingConsumer;
import com.mastfrog.function.throwing.ThrowingRunnable;
import com.mastfrog.function.throwing.ThrowingSupplier;
import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.tasks.Rollback;
import com.telenav.cactus.tasks.RollbackTaskImpl;
import com.telenav.cactus.tasks.Task;
import com.telenav.cactus.tasks.TaskGroup;
import com.telenav.cactus.tasks.TaskGroupImpl;
import com.telenav.cactus.tasks.TaskImpl;
import com.telenav.cactus.tasks.TaskSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

final class Tasks
implements TaskSet {
    private final List<Task> children = new CopyOnWriteArrayList<Task>();
    private final Consumer<String> log;
    private final String name;

    Tasks() {
        this("root");
    }

    Tasks(String name) {
        this.name = name;
        this.log = System.out::println;
    }

    Tasks(String name, Consumer<String> log) {
        this.name = name;
        this.log = log;
    }

    Tasks(Consumer<String> log) {
        this("root", log);
    }

    @Override
    public Iterator<Task> iterator() {
        return Collections.unmodifiableList(this.children).iterator();
    }

    @Override
    public Tasks add(String name, ThrowingRunnable run) {
        this.children.add(new TaskImpl((String)Checks.notNull((String)"name", (Object)name), (ThrowingRunnable)Checks.notNull((String)"run", (Object)run)));
        return this;
    }

    @Override
    public Tasks add(String name, ThrowingSupplier<ThrowingRunnable> run) {
        this.children.add(new RollbackTaskImpl((String)Checks.notNull((String)"name", (Object)name), (ThrowingSupplier<ThrowingRunnable>)((ThrowingSupplier)Checks.notNull((String)"run", run))));
        return this;
    }

    @Override
    public TaskGroup group(String name) {
        TaskGroupImpl group = new TaskGroupImpl(name);
        this.children.add(group);
        return group;
    }

    @Override
    public Tasks group(String name, ThrowingConsumer<TaskGroup> groupConsumer) {
        TaskGroup result = this.group(name);
        groupConsumer.toNonThrowing().accept(result);
        return this;
    }

    @Override
    public void execute() throws Exception {
        Rollback rollback = new Rollback();
        this.log.accept(this.name());
        Set executed = Collections.newSetFromMap(new IdentityHashMap());
        while (!this.children.isEmpty()) {
            try {
                rollback.executeWithRollback(() -> {
                    ArrayList<Task> copy = new ArrayList<Task>(this.children);
                    for (Task kid : copy) {
                        kid.accept(this.log, rollback);
                        executed.add(kid);
                    }
                });
            }
            finally {
                this.children.removeAll(executed);
                executed.clear();
            }
        }
    }

    @Override
    public Tasks add(Task task) {
        this.children.add((Task)Checks.notNull((String)"task", (Object)task));
        return this;
    }

    public void accept(Consumer<String> logger, Rollback rollbacks) throws Exception {
        for (Task t : this.children) {
            t.accept(logger, rollbacks);
        }
    }

    @Override
    public StringBuilder stringify(int depth, StringBuilder into) {
        return TaskSet.super.stringify(depth, into);
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Task t : this.children) {
            t.stringify(sb);
        }
        return sb.toString();
    }

    @Override
    public boolean isEmpty() {
        boolean result = this.children.isEmpty();
        if (!result) {
            result = true;
            for (Task t : this.children) {
                if (t.isEmpty()) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

