/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.util;

import com.mastfrog.function.state.Int;
import com.mastfrog.function.throwing.ThrowingRunnable;
import com.mastfrog.util.preconditions.Checks;
import com.telenav.cactus.maven.log.BuildLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class PathUtils {
    private static final Map<String, Optional<Path>> BINARY_PATH_CACHE = new ConcurrentHashMap<String, Optional<Path>>();

    public static Path home() {
        return PathUtils.fromSystemProperty("user.home", () -> PathUtils.fromSystemProperty("java.io.tmpdir", () -> Paths.get("/", new String[0])));
    }

    private static Path fromSystemProperty(String what, Supplier<Path> fallback) {
        String prop = System.getProperty(what);
        return prop == null ? fallback.get() : Paths.get(prop, new String[0]);
    }

    public static Optional<Path> ifExists(Path path) {
        if (path == null) {
            return Optional.empty();
        }
        if (Files.exists(path, new LinkOption[0])) {
            return Optional.of(path);
        }
        return Optional.empty();
    }

    public static Optional<Path> ifDirectory(Path path) {
        return PathUtils.ifExists(path).flatMap(maybeDir -> Files.isDirectory(maybeDir, new LinkOption[0]) ? Optional.of(maybeDir) : Optional.empty());
    }

    public static String homeRelativePath(Path what) {
        Path home = PathUtils.home();
        if (what.startsWith(home)) {
            return "~/" + home.relativize(what).toString();
        }
        return what.toString();
    }

    public static Optional<Path> findExecutable(String name, Path ... additionalSearchLocations) {
        if (additionalSearchLocations.length == 0) {
            return BINARY_PATH_CACHE.computeIfAbsent(name, n -> PathUtils._findExecutable(n, new Path[0]));
        }
        return PathUtils._findExecutable(name, additionalSearchLocations);
    }

    private static Optional<Path> _findExecutable(String name, Path ... additionalSearchLocations) {
        if (name.indexOf(File.separatorChar) >= 0) {
            Path path = Paths.get(name, new String[0]);
            if (Files.exists(path, new LinkOption[0]) && Files.isExecutable(path)) {
                return Optional.of(path);
            }
            name = path.getFileName().toString();
        }
        String systemPath = System.getenv("PATH");
        LinkedHashSet<Path> all = new LinkedHashSet<Path>(Arrays.asList(additionalSearchLocations));
        if (systemPath != null) {
            for (String s : systemPath.split(":")) {
                all.add(Paths.get(s, new String[0]));
            }
        }
        Path home = PathUtils.home();
        all.addAll(Arrays.asList(Paths.get("/bin", new String[0]), Paths.get("/usr/bin", new String[0]), Paths.get("/usr/local/bin", new String[0]), Paths.get("/opt/bin", new String[0]), Paths.get("/opt/local/bin", new String[0]), Paths.get("/opt/homebrew/bin", new String[0]), home.resolve(".local").resolve("bin"), home.resolve("bin")));
        return PathUtils.findExecutable(all, name);
    }

    public static Optional<Path> findExecutable(Iterable<? extends Path> in, String name) {
        for (Path path : in) {
            Path target = path.resolve(name);
            if (!Files.exists(target, new LinkOption[0]) || !Files.isExecutable(target)) continue;
            return Optional.of(target);
        }
        return Optional.empty();
    }

    public static Optional<Path> findGitCheckoutRoot(Path of, boolean skipSubmodules) {
        return PathUtils.findParentWithChild(of, skipSubmodules ? FileKind.FOLDER : FileKind.EITHER, ".git");
    }

    public static Optional<Path> findParentWithChild(Path of, FileKind dirOrFile, String fileOrFolderName) {
        return PathUtils.findInParents(of, path -> {
            Path child = path.resolve(fileOrFolderName);
            return dirOrFile.test(child);
        });
    }

    public static Optional<Path> findInParents(Path of, Predicate<Path> test) {
        if (!Files.isDirectory((Path)Checks.notNull((String)"of", (Object)of), new LinkOption[0])) {
            of = of.getParent();
        }
        while (of != null) {
            if (test.test(of)) {
                return Optional.of(of);
            }
            of = of.getParent();
        }
        return Optional.empty();
    }

    public static Path userCacheRoot() {
        Path home = Paths.get(System.getProperty("user.home", System.getenv("HOME")), new String[0]);
        String os = System.getProperty("os.name");
        if ("Mac OS X".equals(os)) {
            return home.resolve("Library").resolve("Caches");
        }
        return home.resolve(".cache");
    }

    public static Path temp() {
        return Paths.get(System.getProperty("java.io.tmpdir", "/tmp"), new String[0]);
    }

    public static void deleteWithSubtree(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("Not a directory: " + dir);
        }
        HashSet paths = new HashSet();
        while (true) {
            try (Stream<Path> all2 = Files.walk(dir, new FileVisitOption[0]);){
                all2.forEach(paths::add);
            }
            catch (NoSuchFileException all2) {
                continue;
            }
            break;
        }
        ArrayList l = new ArrayList(paths);
        l.sort((pa, pb) -> -Integer.compare(pa.getNameCount(), pb.getNameCount()));
        for (Path p : l) {
            try {
                Files.delete(p);
            }
            catch (NoSuchFileException noSuchFileException) {}
        }
    }

    public static int deleteFolderTree(Path path) throws IOException {
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return 0;
        }
        List all = Files.walk(path, 1000, new FileVisitOption[0]).collect(Collectors.toCollection(ArrayList::new));
        Collections.sort(all, (a, b) -> Integer.compare(b.getNameCount(), a.getNameCount()));
        int result = 0;
        for (Path fileOrFolder : all) {
            if (!Files.deleteIfExists(fileOrFolder)) continue;
            ++result;
        }
        if (Files.deleteIfExists(path)) {
            ++result;
        }
        return result;
    }

    public static int[] copyFolderTree(BuildLog log, Path from, Path to) throws IOException {
        Int files = Int.create();
        Int dirs = Int.create();
        try (Stream<Path> srcStream = Files.walk(from, 1280, new FileVisitOption[0]);){
            srcStream.forEach(fileOrDir -> {
                Path rel = from.relativize((Path)fileOrDir);
                Path target = to.resolve(rel);
                boolean dir = Files.isDirectory(fileOrDir, new LinkOption[0]);
                PathUtils.quietly(() -> {
                    Path destDir;
                    Path path = destDir = dir ? target : target.getParent();
                    if (!Files.exists(destDir, new LinkOption[0])) {
                        Files.createDirectories(destDir, new FileAttribute[0]);
                        dirs.increment();
                    }
                    if (!dir) {
                        if (!Files.exists(fileOrDir, new LinkOption[0])) {
                            Files.copy(fileOrDir, target, new CopyOption[0]);
                        } else {
                            Files.copy(fileOrDir, target, StandardCopyOption.REPLACE_EXISTING);
                        }
                        files.increment();
                    }
                });
            });
        }
        return new int[]{files.getAsInt(), dirs.getAsInt()};
    }

    public static void unzip(InputStream in, Path dir) throws IOException {
        Checks.notNull((String)"dir", (Object)dir);
        try (ZipInputStream zip = new ZipInputStream((InputStream)Checks.notNull((String)"in", (Object)in));){
            ZipEntry en;
            while ((en = zip.getNextEntry()) != null) {
                Path dest;
                if (en.isDirectory()) {
                    dest = dir.resolve(en.getName());
                    if (Files.exists(dest, new LinkOption[0])) continue;
                    Files.createDirectories(dest, new FileAttribute[0]);
                    continue;
                }
                dest = dir.resolve(en.getName());
                if (!Files.exists(dest.getParent(), new LinkOption[0])) {
                    Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                }
                Files.copy(zip, dest, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private static void quietly(ThrowingRunnable tr) {
        tr.toNonThrowing().run();
    }

    private PathUtils() {
        throw new AssertionError();
    }

    public static enum FileKind implements Predicate<Path>
    {
        FILE,
        FOLDER,
        EITHER;


        @Override
        public boolean test(Path t) {
            boolean result = Files.exists(t, new LinkOption[0]);
            if (result) {
                switch (this) {
                    case FILE: {
                        result = !Files.isDirectory(t, new LinkOption[0]);
                        break;
                    }
                    case FOLDER: {
                        result = Files.isDirectory(t, new LinkOption[0]);
                        break;
                    }
                }
            }
            return result;
        }
    }
}

