/*
 * Decompiled with CFR 0.152.
 */
package com.telenav.cactus.util;

import com.mastfrog.util.preconditions.Checks;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;

public final class EnumMatcher<E extends Enum<E>>
implements Iterable<E> {
    private final E[] values;

    EnumMatcher(Class<E> type) {
        this.values = (Enum[])((Class)Checks.notNull((String)"type", type)).getEnumConstants();
    }

    public static <E extends Enum<E>> EnumMatcher<E> enumMatcher(Class<E> type) {
        return new EnumMatcher<E>(type);
    }

    public E match(String what, E failover) {
        Checks.notNull((String)"failover", failover);
        if (what == null) {
            return failover;
        }
        return (E)((Enum)this.match(what.trim()).orElse(failover));
    }

    public Optional<E> match(String what) {
        if (what == null || what.isEmpty()) {
            return Optional.empty();
        }
        what = what.trim();
        for (Enum e : this) {
            if (!this.isMatch(e, what)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public E matchOrThrow(String what) {
        return (E)((Enum)this.match(what).orElseThrow(() -> {
            StringBuilder sb = new StringBuilder("Invalid value '").append(what).append("' for a ").append(this.values.getClass().getComponentType().getSimpleName()).append(". Possible values: ");
            for (int i = 0; i < this.values.length; ++i) {
                sb.append(EnumMatcher.hyphenatedLower(this.values[i]));
                if (i >= this.values.length - 1) continue;
                sb.append(", ");
            }
            return new IllegalArgumentException(sb.toString());
        }));
    }

    private boolean isMatch(E toTest, String with) {
        return with.equals(((Enum)toTest).name()) || with.equals(EnumMatcher.lowerCase(toTest)) || with.equals(EnumMatcher.hyphenated(toTest)) || with.equals(EnumMatcher.hyphenatedLower(toTest));
    }

    private static String lowerCase(Enum<?> e) {
        return e.name().toLowerCase();
    }

    private static String hyphenated(Enum<?> e) {
        return e.name().replace('_', '-');
    }

    private static String hyphenatedLower(Enum<?> e) {
        return EnumMatcher.lowerCase(e).replace('_', '-');
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (E item : this.values) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(((Enum)item).name().toLowerCase().replace('_', '-'));
        }
        return sb.toString();
    }

    @Override
    public Iterator<E> iterator() {
        return Arrays.asList(this.values).iterator();
    }
}

