/*
 * Decompiled with CFR 0.152.
 */
package com.tenable.library.kafkaclient.client.standard;

import cats.Applicative;
import cats.Apply;
import cats.Functor;
import cats.effect.ConcurrentEffect;
import cats.effect.ConcurrentEffect$;
import cats.effect.ContextShift;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.ResourceLike;
import cats.effect.Timer;
import cats.effect.concurrent.MVar;
import cats.effect.concurrent.MVar$;
import cats.syntax.package;
import com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO;
import com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$;
import com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$Builder$;
import com.tenable.library.kafkaclient.client.standard.consumer.ConsumerStateHandler;
import com.tenable.library.kafkaclient.client.standard.consumer.KafkaRunLoop;
import com.tenable.library.kafkaclient.client.standard.consumer.KafkaRunLoop$;
import com.tenable.library.kafkaclient.client.standard.consumer.PausedTemporarily;
import com.tenable.library.kafkaclient.client.standard.consumer.State;
import com.tenable.library.kafkaclient.config.KafkaConsumerConfig;
import com.tenable.library.kafkaclient.utils.Converters$;
import com.tenable.library.kafkaclient.utils.Converters$JavaDurationOps$;
import com.tenable.library.kafkaclient.utils.ExecutionContexts$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import java.util.HashMap;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

public final class KafkaConsumerIO$ {
    public static final KafkaConsumerIO$ MODULE$ = new KafkaConsumerIO$();
    private static volatile boolean bitmap$init$0;

    public <F, K, V> KafkaConsumerIO.Builder<KafkaConsumerIO.CreatedEmpty, F, K, V> builder(KafkaConsumerConfig config, ConcurrentEffect<F> evidence$4, ContextShift<F> evidence$5, Timer<F> evidence$6) {
        return new KafkaConsumerIO.Builder(config, None$.MODULE$, None$.MODULE$, None$.MODULE$, KafkaConsumerIO$Builder$.MODULE$.$lessinit$greater$default$5(), evidence$4, evidence$5, evidence$6);
    }

    public <F, K, V> Resource<F, KafkaConsumerIO<F, K, V>> com$tenable$library$kafkaclient$client$standard$KafkaConsumerIO$$resource(KafkaConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, Option<Resource<F, ExecutionContext>> optionalBlockingEC, Function1<KafkaConsumer<K, V>, ConsumerRebalanceListener> rebalanceListener, ConcurrentEffect<F> evidence$7, ContextShift<F> evidence$8, Timer<F> evidence$9) {
        return ((ResourceLike)optionalBlockingEC.getOrElse((Function0 & Serializable)() -> ExecutionContexts$.MODULE$.io("kafka-consumer", evidence$7))).flatMap((Function1 & Serializable)ec -> Resource$.MODULE$.make(MODULE$.create(config, keyDeserializer, valueDeserializer, (ExecutionContext)ec, rebalanceListener, evidence$7, evidence$8, evidence$9), (Function1 & Serializable)x$3 -> x$3.close(), (Functor)evidence$7).map((Function1 & Serializable)consumer -> consumer, (Applicative)evidence$7));
    }

    private <F, K, V> F create(KafkaConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, ExecutionContext blockingEC, Function1<KafkaConsumer<K, V>, ConsumerRebalanceListener> rebalanceListener, ConcurrentEffect<F> evidence$10, ContextShift<F> evidence$11, Timer<F> evidence$12) {
        Logger logger = LoggerFactory.getLogger((String)new StringBuilder(9).append("kafka-io-").append(config.clientId()).toString().replace('.', '-'));
        Function0 & Serializable consumerBuilder = (Function0 & Serializable)() -> {
            KafkaConsumer c = new KafkaConsumer(config.properties(), keyDeserializer, valueDeserializer);
            java.util.Set subscribedTopics = CollectionConverters$.MODULE$.SetHasAsJava(config.topics()).asJava();
            c.subscribe((Collection)subscribedTopics, (ConsumerRebalanceListener)rebalanceListener.apply((Object)c));
            return c;
        };
        Function1 & Serializable consumerStateHandler = (Function1 & Serializable)x$4 -> new ConsumerStateHandler(config.clientId(), config.fakePollInterval(), consumerBuilder, x$4, blockingEC, evidence$10, evidence$11, evidence$12, logger);
        return (F)package.functor$.MODULE$.toFunctorOps(package.flatMap$.MODULE$.toFlatMapOps(package.functor$.MODULE$.toFunctorOps(MVar.ApplyBuilders$.MODULE$.empty$extension(MVar$.MODULE$.apply(evidence$10)), evidence$10).map((Function1)consumerStateHandler), evidence$10).flatTap((Function1 & Serializable)x$5 -> x$5.unsafeStart((scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty())), evidence$10).map((Function1 & Serializable)stateHandler -> MODULE$.apply((ConsumerStateHandler)stateHandler, evidence$10, evidence$12, logger));
    }

    private <F, K, V> KafkaConsumerIO<F, K, V> apply(ConsumerStateHandler<F, K, V> stateHandler, ConcurrentEffect<F> evidence$13, Timer<F> evidence$14, Logger logger) {
        return new KafkaConsumerIO<F, K, V>(evidence$13, stateHandler, evidence$14, logger){
            private final ConcurrentEffect<F> F;
            private final String clientId;
            private volatile byte bitmap$init$0;
            private final ConcurrentEffect evidence$13$1;
            private final ConsumerStateHandler stateHandler$1;
            private final Timer evidence$14$1;
            private final Logger logger$2;

            private ConcurrentEffect<F> F() {
                if ((byte)(this.bitmap$init$0 & 1) == 0) {
                    throw new UninitializedFieldError("Uninitialized field: /home/ubuntu/workspace/tio-sdk_Kastle_master/src/main/scala/com/tenable/library/kafkaclient/client/standard/KafkaConsumerIO.scala: 205");
                }
                return this.F;
            }

            public String clientId() {
                if ((byte)(this.bitmap$init$0 & 2) == 0) {
                    throw new UninitializedFieldError("Uninitialized field: /home/ubuntu/workspace/tio-sdk_Kastle_master/src/main/scala/com/tenable/library/kafkaclient/client/standard/KafkaConsumerIO.scala: 207");
                }
                return this.clientId;
            }

            public KafkaRunLoop.Builder<KafkaRunLoop.CreatedEmpty, F, K, V, Nothing$, Nothing$> pollForever() {
                return KafkaRunLoop$.MODULE$.builder(this, this.evidence$13$1, this.evidence$14$1);
            }

            public F rawPoll(Duration timeout) {
                return (F)package.apply$.MODULE$.catsSyntaxApply(this.stateHandler$1.refreshTemporarilyPaused(), (Apply)this.evidence$13$1).$times$greater(this.stateHandler$1.withConsumer("poll", this.stateHandler$1.withConsumer$default$2(), (Function1 & Serializable)state -> state.isClosed() ? this.F().pure((Object)new Tuple2(state, this.emptyConsumerRecords())) : this.F().delay((Function0 & Serializable)() -> {
                    $this.logger$2.debug("Polling");
                    return new Tuple2(state, (Object)state.consumer().poll(Converters$JavaDurationOps$.MODULE$.asJavaDuration$extension(Converters$.MODULE$.JavaDurationOps(timeout))));
                })));
            }

            public <R> F poll(Duration timeout, Function1<ConsumerRecords<K, V>, R> f) {
                return (F)package.functor$.MODULE$.toFunctorOps(this.rawPoll(timeout), (Functor)this.evidence$13$1).map(f);
            }

            public F close() {
                return this.stateHandler$1.closeConsumer((Option<Duration>)None$.MODULE$);
            }

            public F close(Duration timeout) {
                return this.stateHandler$1.closeConsumer((Option<Duration>)new Some((Object)timeout));
            }

            public F pause(String topic) {
                return this.stateHandler$1.withConsumer("pause", (Option<String>)new Some((Object)new StringBuilder(14).append("Pausing topic ").append(topic).toString()), (Function1 & Serializable)state -> this.F().delay((Function0 & Serializable)() -> {
                    scala.collection.mutable.Set tps = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(state.consumer().assignment()).asScala().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$pause$3(topic, x$6)));
                    state.consumer().pause((Collection)CollectionConverters$.MODULE$.MutableSetHasAsJava(tps).asJava());
                    scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)state.pausedT().$plus((Object)topic);
                    Consumer<K, V> x$2 = state.copy$default$1();
                    scala.collection.immutable.Map<TopicPartition, PausedTemporarily> x$3 = state.copy$default$2();
                    F x$4 = state.copy$default$4();
                    boolean x$5 = state.copy$default$5();
                    return new Tuple2(state.copy(x$2, x$3, (scala.collection.immutable.Set<String>)x$1, x$4, x$5), (Object)BoxedUnit.UNIT);
                }));
            }

            public F pause(scala.collection.immutable.Map<TopicPartition, PausedTemporarily> details) {
                return this.stateHandler$1.withConsumer("batch-pause", (Option<String>)new Some((Object)new StringBuilder(8).append("Pausing ").append(details.map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TopicPartition k = (TopicPartition)tuple2._1();
                    PausedTemporarily v = (PausedTemporarily)tuple2._2();
                    String string = new StringBuilder(4).append(k).append(" -> ").append(v).toString();
                    return string;
                })).toString()), (Function1 & Serializable)state -> this.F().delay((Function0 & Serializable)() -> {
                    state.consumer().pause((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)details.keySet()).asJava());
                    scala.collection.immutable.Map x$1 = (scala.collection.immutable.Map)state.pausedTP().$plus$plus((IterableOnce)details);
                    Consumer<K, V> x$2 = state.copy$default$1();
                    scala.collection.immutable.Set<String> x$3 = state.copy$default$3();
                    F x$4 = state.copy$default$4();
                    boolean x$5 = state.copy$default$5();
                    return new Tuple2(state.copy(x$2, (scala.collection.immutable.Map<TopicPartition, PausedTemporarily>)x$1, x$3, x$4, x$5), (Object)BoxedUnit.UNIT);
                }));
            }

            public F paused() {
                return this.stateHandler$1.withConsumer("paused", (Option<String>)new Some((Object)"Listing paused topics"), (Function1 & Serializable)state -> this.F().delay((Function0 & Serializable)() -> new Tuple2(state, (Object)CollectionConverters$.MODULE$.SetHasAsScala(state.consumer().paused()).asScala().toSet())));
            }

            public F resume(String topic) {
                return this.stateHandler$1.withConsumer("resume", (Option<String>)new Some((Object)new StringBuilder(15).append("Resuming topic ").append(topic).toString()), (Function1 & Serializable)state -> this.F().delay((Function0 & Serializable)() -> {
                    scala.collection.mutable.Set tps = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(state.consumer().assignment()).asScala().filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$resume$3(topic, x$7)));
                    state.consumer().resume((Collection)CollectionConverters$.MODULE$.MutableSetHasAsJava(tps).asJava());
                    scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)state.pausedT().$minus((Object)topic);
                    Consumer<K, V> x$2 = state.copy$default$1();
                    scala.collection.immutable.Map<TopicPartition, PausedTemporarily> x$3 = state.copy$default$2();
                    F x$4 = state.copy$default$4();
                    boolean x$5 = state.copy$default$5();
                    return new Tuple2(state.copy(x$2, x$3, (scala.collection.immutable.Set<String>)x$1, x$4, x$5), (Object)BoxedUnit.UNIT);
                }));
            }

            public F resume(scala.collection.immutable.Set<TopicPartition> topicPartitions) {
                return this.stateHandler$1.withConsumer("batch-resume", (Option<String>)new Some((Object)new StringBuilder(9).append("Resuming ").append(topicPartitions).toString()), (Function1 & Serializable)state -> this.F().delay((Function0 & Serializable)() -> {
                    scala.collection.mutable.Set tps = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(state.consumer().assignment()).asScala().filter((Function1)topicPartitions);
                    state.consumer().resume((Collection)CollectionConverters$.MODULE$.MutableSetHasAsJava(tps).asJava());
                    scala.collection.immutable.Map x$1 = (scala.collection.immutable.Map)state.pausedTP().filterNot((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$resume$6(topicPartitions, x0$1)));
                    Consumer<K, V> x$2 = state.copy$default$1();
                    scala.collection.immutable.Set<String> x$3 = state.copy$default$3();
                    F x$4 = state.copy$default$4();
                    boolean x$5 = state.copy$default$5();
                    return new Tuple2(state.copy(x$2, (scala.collection.immutable.Map<TopicPartition, PausedTemporarily>)x$1, x$3, x$4, x$5), (Object)BoxedUnit.UNIT);
                }));
            }

            public F commitSync(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
                return this.stateHandler$1.withConsumer("batch-commit", this.stateHandler$1.withConsumer$default$2(), (Function1 & Serializable)state -> this.F().delay((Function0 & Serializable)() -> {
                    state.consumer().commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)offsets.view().mapValues((Function1 & Serializable)o -> anon.1.$anonfun$commitSync$3(BoxesRunTime.unboxToLong((Object)o))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
                    return new Tuple2(state, (Object)BoxedUnit.UNIT);
                }));
            }

            public F commitAsync(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
                return this.stateHandler$1.withConsumer("batch-commit-async", this.stateHandler$1.withConsumer$default$2(), (Function1 & Serializable)state -> this.F().delay((Function0 & Serializable)() -> {
                    state.consumer().commitAsync(CollectionConverters$.MODULE$.MapHasAsJava((Map)offsets.view().mapValues((Function1 & Serializable)o -> anon.1.$anonfun$commitAsync$3(BoxesRunTime.unboxToLong((Object)o))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava(), null);
                    return new Tuple2(state, (Object)BoxedUnit.UNIT);
                }));
            }

            public F listTopics() {
                return this.stateHandler$1.withConsumer("list-topics", (Option<String>)new Some((Object)"Listing all topics"), (Function1 & Serializable)state -> this.F().delay((Function0 & Serializable)() -> new Tuple2(state, (Object)CollectionConverters$.MODULE$.MapHasAsScala(state.consumer().listTopics()).asScala().view().mapValues((Function1 & Serializable)x$8 -> CollectionConverters$.MODULE$.ListHasAsScala(x$8).asScala().toList()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
            }

            public F listTopics(Duration duration) {
                return this.stateHandler$1.withConsumer("list-topics-by-duration", (Option<String>)new Some((Object)new StringBuilder(23).append("Listing all topics for ").append(duration).toString()), (Function1 & Serializable)state -> this.F().delay((Function0 & Serializable)() -> new Tuple2(state, (Object)CollectionConverters$.MODULE$.MapHasAsScala(state.consumer().listTopics(Converters$JavaDurationOps$.MODULE$.asJavaDuration$extension(Converters$.MODULE$.JavaDurationOps(duration)))).asScala().view().mapValues((Function1 & Serializable)x$9 -> CollectionConverters$.MODULE$.ListHasAsScala(x$9).asScala().toList()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
            }

            public F position(TopicPartition topicPartition) {
                return this.stateHandler$1.withConsumer("position", (Option<String>)new Some((Object)new StringBuilder(21).append("Getting position for ").append(topicPartition).toString()), (Function1 & Serializable)state -> this.F().delay((Function0 & Serializable)() -> new Tuple2(state, (Object)BoxesRunTime.boxToLong((long)state.consumer().position(topicPartition)))));
            }

            public F position(TopicPartition topicPartition, Duration duration) {
                return this.stateHandler$1.withConsumer("position-by-duration", (Option<String>)new Some((Object)new StringBuilder(26).append("Getting position for ").append(topicPartition).append(" and ").append(duration).toString()), (Function1 & Serializable)state -> this.F().delay((Function0 & Serializable)() -> new Tuple2(state, (Object)BoxesRunTime.boxToLong((long)state.consumer().position(topicPartition, Converters$JavaDurationOps$.MODULE$.asJavaDuration$extension(Converters$.MODULE$.JavaDurationOps(duration)))))));
            }

            public F committed(TopicPartition topicPartition) {
                return this.stateHandler$1.withConsumer("committed", (Option<String>)new Some((Object)new StringBuilder(30).append("Getting committed offsets for ").append(topicPartition).toString()), (Function1 & Serializable)state -> this.F().delay((Function0 & Serializable)() -> new Tuple2(state, (Object)state.consumer().committed(topicPartition))));
            }

            public F committed(TopicPartition topicPartition, Duration duration) {
                return this.stateHandler$1.withConsumer("committed-by-duration", (Option<String>)new Some((Object)new StringBuilder(35).append("Getting committed offsets for ").append(topicPartition).append(" and ").append(duration).toString()), (Function1 & Serializable)state -> this.F().delay((Function0 & Serializable)() -> new Tuple2(state, (Object)state.consumer().committed(topicPartition, Converters$JavaDurationOps$.MODULE$.asJavaDuration$extension(Converters$.MODULE$.JavaDurationOps(duration))))));
            }

            public F assignment() {
                return this.stateHandler$1.withConsumer("assignment", (Option<String>)new Some((Object)"Getting assignment"), (Function1 & Serializable)state -> this.F().delay((Function0 & Serializable)() -> new Tuple2(state, (Object)CollectionConverters$.MODULE$.SetHasAsScala(state.consumer().assignment()).asScala().toSet())));
            }

            public F seek(TopicPartition topicPartition, long offset) {
                return this.stateHandler$1.withConsumer("seek", (Option<String>)new Some((Object)new StringBuilder(16).append("Seeking to ").append(offset).append(" for ").append(topicPartition).toString()), (Function1 & Serializable)state -> this.F().delay((Function0 & Serializable)() -> {
                    state.consumer().seek(topicPartition, offset);
                    return new Tuple2(state, (Object)BoxedUnit.UNIT);
                }));
            }

            public F seekToEnd(List<TopicPartition> topicPartitions) {
                return this.stateHandler$1.withConsumer("seek-to-end", (Option<String>)new Some((Object)new StringBuilder(19).append("Seeking to end for ").append(topicPartitions).toString()), (Function1 & Serializable)state -> this.F().delay((Function0 & Serializable)() -> {
                    state.consumer().seekToEnd((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topicPartitions).asJava());
                    return new Tuple2(state, (Object)BoxedUnit.UNIT);
                }));
            }

            public F seekToBeginning(List<TopicPartition> topicPartitions) {
                return this.stateHandler$1.withConsumer("seek-to-beginning", (Option<String>)new Some((Object)new StringBuilder(25).append("Seeking to beginning for ").append(topicPartitions).toString()), (Function1 & Serializable)state -> this.F().delay((Function0 & Serializable)() -> {
                    state.consumer().seekToBeginning((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topicPartitions).asJava());
                    return new Tuple2(state, (Object)BoxedUnit.UNIT);
                }));
            }

            public F seekWithError(scala.collection.immutable.Map<TopicPartition, Object> offsets, Option<String> error) {
                return this.stateHandler$1.withConsumer("batch-seek-with-error", this.stateHandler$1.withConsumer$default$2(), (Function1 & Serializable)state -> this.F().delay((Function0 & Serializable)() -> {
                    String msg = new StringBuilder(9).append("Seeking (").append(offsets.map((Function1 & Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        TopicPartition k = (TopicPartition)tuple2._1();
                        long v = tuple2._2$mcJ$sp();
                        String string = new StringBuilder(4).append(k).append(" -> ").append(v).toString();
                        return string;
                    })).toString();
                    error.fold((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.logger$2.info(msg), (Function1 & Serializable)err -> {
                        anon.1.$anonfun$seekWithError$5(this, msg, err);
                        return BoxedUnit.UNIT;
                    });
                    offsets.foreach((Function1 & Serializable)x0$2 -> {
                        anon.1.$anonfun$seekWithError$6(state, x0$2);
                        return BoxedUnit.UNIT;
                    });
                    return new Tuple2(state, (Object)BoxedUnit.UNIT);
                }));
            }

            public F restartOnError(Throwable error) {
                return this.stateHandler$1.restartOnError(error);
            }

            private ConsumerRecords<K, V> emptyConsumerRecords() {
                return new ConsumerRecords(new HashMap<K, V>());
            }

            public static final /* synthetic */ boolean $anonfun$pause$3(String topic$1, TopicPartition x$6) {
                String string = x$6.topic();
                String string2 = topic$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }

            public static final /* synthetic */ boolean $anonfun$resume$3(String topic$2, TopicPartition x$7) {
                String string = x$7.topic();
                String string2 = topic$2;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }

            public static final /* synthetic */ boolean $anonfun$resume$6(scala.collection.immutable.Set topicPartitions$1, Tuple2 x0$1) {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition k = (TopicPartition)tuple2._1();
                boolean bl = topicPartitions$1.contains((Object)k);
                return bl;
            }

            public static final /* synthetic */ OffsetAndMetadata $anonfun$commitSync$3(long o) {
                return new OffsetAndMetadata(o);
            }

            public static final /* synthetic */ OffsetAndMetadata $anonfun$commitAsync$3(long o) {
                return new OffsetAndMetadata(o);
            }

            public static final /* synthetic */ void $anonfun$seekWithError$5(anon.1 $this, String msg$1, String err) {
                $this.logger$2.error(new StringBuilder(15).append(msg$1).append(", due to error ").append(err).toString());
            }

            public static final /* synthetic */ void $anonfun$seekWithError$6(State state$19, Tuple2 x0$2) {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition partition = (TopicPartition)tuple2._1();
                long offset = tuple2._2$mcJ$sp();
                state$19.consumer().seek(partition, offset);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            {
                this.evidence$13$1 = evidence$13$1;
                this.stateHandler$1 = stateHandler$1;
                this.evidence$14$1 = evidence$14$1;
                this.logger$2 = logger$2;
                this.F = ConcurrentEffect$.MODULE$.apply(evidence$13$1);
                this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
                this.clientId = stateHandler$1.clientId();
                this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$assignment$1(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$assignment$2(com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$commitAsync$1(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 scala.collection.immutable.Map com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$commitAsync$2(com.tenable.library.kafkaclient.client.standard.consumer.State scala.collection.immutable.Map ), $anonfun$commitAsync$3$adapted(java.lang.Object ), $anonfun$commitSync$1(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 scala.collection.immutable.Map com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$commitSync$2(com.tenable.library.kafkaclient.client.standard.consumer.State scala.collection.immutable.Map ), $anonfun$commitSync$3$adapted(java.lang.Object ), $anonfun$committed$1(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 org.apache.kafka.common.TopicPartition com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$committed$2(com.tenable.library.kafkaclient.client.standard.consumer.State org.apache.kafka.common.TopicPartition ), $anonfun$committed$3(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 org.apache.kafka.common.TopicPartition scala.concurrent.duration.Duration com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$committed$4(com.tenable.library.kafkaclient.client.standard.consumer.State org.apache.kafka.common.TopicPartition scala.concurrent.duration.Duration ), $anonfun$listTopics$1(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$listTopics$2(com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$listTopics$3(java.util.List ), $anonfun$listTopics$4(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 scala.concurrent.duration.Duration com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$listTopics$5(com.tenable.library.kafkaclient.client.standard.consumer.State scala.concurrent.duration.Duration ), $anonfun$listTopics$6(java.util.List ), $anonfun$pause$1(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 java.lang.String com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$pause$2(com.tenable.library.kafkaclient.client.standard.consumer.State java.lang.String ), $anonfun$pause$3$adapted(java.lang.String org.apache.kafka.common.TopicPartition ), $anonfun$pause$4(scala.Tuple2 ), $anonfun$pause$5(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 scala.collection.immutable.Map com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$pause$6(com.tenable.library.kafkaclient.client.standard.consumer.State scala.collection.immutable.Map ), $anonfun$paused$1(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$paused$2(com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$position$1(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 org.apache.kafka.common.TopicPartition com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$position$2(com.tenable.library.kafkaclient.client.standard.consumer.State org.apache.kafka.common.TopicPartition ), $anonfun$position$3(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 org.apache.kafka.common.TopicPartition scala.concurrent.duration.Duration com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$position$4(com.tenable.library.kafkaclient.client.standard.consumer.State org.apache.kafka.common.TopicPartition scala.concurrent.duration.Duration ), $anonfun$rawPoll$1(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 scala.concurrent.duration.Duration com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$rawPoll$2(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 com.tenable.library.kafkaclient.client.standard.consumer.State scala.concurrent.duration.Duration ), $anonfun$resume$1(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 java.lang.String com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$resume$2(com.tenable.library.kafkaclient.client.standard.consumer.State java.lang.String ), $anonfun$resume$3$adapted(java.lang.String org.apache.kafka.common.TopicPartition ), $anonfun$resume$4(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 scala.collection.immutable.Set com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$resume$5(com.tenable.library.kafkaclient.client.standard.consumer.State scala.collection.immutable.Set ), $anonfun$resume$6$adapted(scala.collection.immutable.Set scala.Tuple2 ), $anonfun$seek$1(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 org.apache.kafka.common.TopicPartition long com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$seek$2(com.tenable.library.kafkaclient.client.standard.consumer.State org.apache.kafka.common.TopicPartition long ), $anonfun$seekToBeginning$1(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 scala.collection.immutable.List com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$seekToBeginning$2(com.tenable.library.kafkaclient.client.standard.consumer.State scala.collection.immutable.List ), $anonfun$seekToEnd$1(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 scala.collection.immutable.List com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$seekToEnd$2(com.tenable.library.kafkaclient.client.standard.consumer.State scala.collection.immutable.List ), $anonfun$seekWithError$1(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 scala.collection.immutable.Map scala.Option com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$seekWithError$2(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 scala.collection.immutable.Map scala.Option com.tenable.library.kafkaclient.client.standard.consumer.State ), $anonfun$seekWithError$3(scala.Tuple2 ), $anonfun$seekWithError$4(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 java.lang.String ), $anonfun$seekWithError$5$adapted(com.tenable.library.kafkaclient.client.standard.KafkaConsumerIO$$anon$1 java.lang.String java.lang.String ), $anonfun$seekWithError$6$adapted(com.tenable.library.kafkaclient.client.standard.consumer.State scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    private KafkaConsumerIO$() {
    }
}

