/*
 * Marketing API
 * Marketing API
 *
 * OpenAPI spec version: 1.3
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.CreativeSampleProductsGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreativeSampleProductsApi {
  private ApiClient apiClient;

  public CreativeSampleProductsApi() {
    this(Configuration.getDefaultApiClient());
  }

  public CreativeSampleProductsApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Build call for creativeSampleProductsGet
   *
   * @param accountId (required)
   * @param productCatalogId (required)
   * @param productOuterIds (optional)
   * @param productSeriesId (optional)
   * @param templateId (optional)
   * @param templateType (optional)
   * @param imageId (optional)
   * @param videoId (optional)
   * @param productFields (optional)
   * @param limit (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @param progressListener Progress listener
   * @param progressRequestListener Progress request listener
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   */
  public com.squareup.okhttp.Call creativeSampleProductsGetCall(
      Long accountId,
      Long productCatalogId,
      List<String> productOuterIds,
      Long productSeriesId,
      Long templateId,
      String templateType,
      String imageId,
      String videoId,
      List<String> productFields,
      Long limit,
      List<String> fields,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath = "/creative_sample_products/get";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    if (accountId != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("account_id", accountId));
    if (productCatalogId != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("product_catalog_id", productCatalogId));
    if (productOuterIds != null)
      localVarCollectionQueryParams.addAll(
          apiClient.parameterToPairs("multi", "product_outer_ids", productOuterIds));
    if (productSeriesId != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("product_series_id", productSeriesId));
    if (templateId != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("template_id", templateId));
    if (templateType != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("template_type", templateType));
    if (imageId != null) localVarQueryParams.addAll(apiClient.parameterToPair("image_id", imageId));
    if (videoId != null) localVarQueryParams.addAll(apiClient.parameterToPair("video_id", videoId));
    if (productFields != null)
      localVarCollectionQueryParams.addAll(
          apiClient.parameterToPairs("multi", "product_fields", productFields));
    if (limit != null) localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    if (fields != null)
      localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "fields", fields));

    Map<String, String> localVarHeaderParams = new HashMap<String, String>();

    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

    final String[] localVarContentTypes = {"text/plain"};
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    if (progressListener != null) {
      apiClient
          .getHttpClient()
          .networkInterceptors()
          .add(
              new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(
                    com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                  com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                  return originalResponse
                      .newBuilder()
                      .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                      .build();
                }
              });
    }

    String[] localVarAuthNames = new String[] {"accessToken", "nonce", "timestamp"};
    return apiClient.buildCall(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarFormParams,
        localVarAuthNames,
        progressRequestListener);
  }

  @SuppressWarnings("rawtypes")
  private com.squareup.okhttp.Call creativeSampleProductsGetValidateBeforeCall(
      Long accountId,
      Long productCatalogId,
      List<String> productOuterIds,
      Long productSeriesId,
      Long templateId,
      String templateType,
      String imageId,
      String videoId,
      List<String> productFields,
      Long limit,
      List<String> fields,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          "Missing the required parameter 'accountId' when calling creativeSampleProductsGet(Async)");
    }

    // verify the required parameter 'productCatalogId' is set
    if (productCatalogId == null) {
      throw new ApiException(
          "Missing the required parameter 'productCatalogId' when calling creativeSampleProductsGet(Async)");
    }

    com.squareup.okhttp.Call call =
        creativeSampleProductsGetCall(
            accountId,
            productCatalogId,
            productOuterIds,
            productSeriesId,
            templateId,
            templateType,
            imageId,
            videoId,
            productFields,
            limit,
            fields,
            progressListener,
            progressRequestListener);
    return call;
  }

  /**
   * 获取创意示例商品列表
   *
   * @param accountId (required)
   * @param productCatalogId (required)
   * @param productOuterIds (optional)
   * @param productSeriesId (optional)
   * @param templateId (optional)
   * @param templateType (optional)
   * @param imageId (optional)
   * @param videoId (optional)
   * @param productFields (optional)
   * @param limit (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @return CreativeSampleProductsGetResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public CreativeSampleProductsGetResponse creativeSampleProductsGet(
      Long accountId,
      Long productCatalogId,
      List<String> productOuterIds,
      Long productSeriesId,
      Long templateId,
      String templateType,
      String imageId,
      String videoId,
      List<String> productFields,
      Long limit,
      List<String> fields)
      throws ApiException {
    ApiResponse<CreativeSampleProductsGetResponse> resp =
        creativeSampleProductsGetWithHttpInfo(
            accountId,
            productCatalogId,
            productOuterIds,
            productSeriesId,
            templateId,
            templateType,
            imageId,
            videoId,
            productFields,
            limit,
            fields);
    return resp.getData();
  }

  /**
   * 获取创意示例商品列表
   *
   * @param accountId (required)
   * @param productCatalogId (required)
   * @param productOuterIds (optional)
   * @param productSeriesId (optional)
   * @param templateId (optional)
   * @param templateType (optional)
   * @param imageId (optional)
   * @param videoId (optional)
   * @param productFields (optional)
   * @param limit (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @return ApiResponse&lt;CreativeSampleProductsGetResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public ApiResponse<CreativeSampleProductsGetResponse> creativeSampleProductsGetWithHttpInfo(
      Long accountId,
      Long productCatalogId,
      List<String> productOuterIds,
      Long productSeriesId,
      Long templateId,
      String templateType,
      String imageId,
      String videoId,
      List<String> productFields,
      Long limit,
      List<String> fields)
      throws ApiException {
    com.squareup.okhttp.Call call =
        creativeSampleProductsGetValidateBeforeCall(
            accountId,
            productCatalogId,
            productOuterIds,
            productSeriesId,
            templateId,
            templateType,
            imageId,
            videoId,
            productFields,
            limit,
            fields,
            null,
            null);
    Type localVarReturnType = new TypeToken<CreativeSampleProductsGetResponse>() {}.getType();
    return apiClient.execute(call, localVarReturnType);
  }

  /**
   * 获取创意示例商品列表 (asynchronously)
   *
   * @param accountId (required)
   * @param productCatalogId (required)
   * @param productOuterIds (optional)
   * @param productSeriesId (optional)
   * @param templateId (optional)
   * @param templateType (optional)
   * @param imageId (optional)
   * @param videoId (optional)
   * @param productFields (optional)
   * @param limit (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @param callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   */
  public com.squareup.okhttp.Call creativeSampleProductsGetAsync(
      Long accountId,
      Long productCatalogId,
      List<String> productOuterIds,
      Long productSeriesId,
      Long templateId,
      String templateType,
      String imageId,
      String videoId,
      List<String> productFields,
      Long limit,
      List<String> fields,
      final ApiCallback<CreativeSampleProductsGetResponse> callback)
      throws ApiException {

    ProgressResponseBody.ProgressListener progressListener = null;
    ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

    if (callback != null) {
      progressListener =
          new ProgressResponseBody.ProgressListener() {
            @Override
            public void update(long bytesRead, long contentLength, boolean done) {
              callback.onDownloadProgress(bytesRead, contentLength, done);
            }
          };

      progressRequestListener =
          new ProgressRequestBody.ProgressRequestListener() {
            @Override
            public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
              callback.onUploadProgress(bytesWritten, contentLength, done);
            }
          };
    }

    com.squareup.okhttp.Call call =
        creativeSampleProductsGetValidateBeforeCall(
            accountId,
            productCatalogId,
            productOuterIds,
            productSeriesId,
            templateId,
            templateType,
            imageId,
            videoId,
            productFields,
            limit,
            fields,
            progressListener,
            progressRequestListener);
    Type localVarReturnType = new TypeToken<CreativeSampleProductsGetResponse>() {}.getType();
    apiClient.executeAsync(call, localVarReturnType, callback);
    return call;
  }
}
