/*
 * Marketing API
 * Marketing API
 *
 * OpenAPI spec version: 1.3
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.DataSourceDispatchGetResponse;
import com.tencent.ads.model.DataSourceDispatchUpdateRequest;
import com.tencent.ads.model.DataSourceDispatchUpdateResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataSourceDispatchApi {
  private ApiClient apiClient;

  public DataSourceDispatchApi() {
    this(Configuration.getDefaultApiClient());
  }

  public DataSourceDispatchApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Build call for dataSourceDispatchGet
   *
   * @param accountId (required)
   * @param userActionSetId (optional)
   * @param type (optional)
   * @param name (optional)
   * @param scenes (optional)
   * @param switchType (optional)
   * @param accessWay (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @param progressListener Progress listener
   * @param progressRequestListener Progress request listener
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   */
  public com.squareup.okhttp.Call dataSourceDispatchGetCall(
      Long accountId,
      Long userActionSetId,
      String type,
      String name,
      List<String> scenes,
      String switchType,
      String accessWay,
      List<String> fields,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath = "/data_source_dispatch/get";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    if (accountId != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("account_id", accountId));
    if (userActionSetId != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("user_action_set_id", userActionSetId));
    if (type != null) localVarQueryParams.addAll(apiClient.parameterToPair("type", type));
    if (name != null) localVarQueryParams.addAll(apiClient.parameterToPair("name", name));
    if (scenes != null)
      localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "scenes", scenes));
    if (switchType != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("switch_type", switchType));
    if (accessWay != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("access_way", accessWay));
    if (fields != null)
      localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "fields", fields));

    Map<String, String> localVarHeaderParams = new HashMap<String, String>();

    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

    final String[] localVarContentTypes = {"text/plain"};
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    if (progressListener != null) {
      apiClient
          .getHttpClient()
          .networkInterceptors()
          .add(
              new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(
                    com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                  com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                  return originalResponse
                      .newBuilder()
                      .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                      .build();
                }
              });
    }

    String[] localVarAuthNames = new String[] {"accessToken", "nonce", "timestamp"};
    return apiClient.buildCall(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarFormParams,
        localVarAuthNames,
        progressRequestListener);
  }

  @SuppressWarnings("rawtypes")
  private com.squareup.okhttp.Call dataSourceDispatchGetValidateBeforeCall(
      Long accountId,
      Long userActionSetId,
      String type,
      String name,
      List<String> scenes,
      String switchType,
      String accessWay,
      List<String> fields,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          "Missing the required parameter 'accountId' when calling dataSourceDispatchGet(Async)");
    }

    com.squareup.okhttp.Call call =
        dataSourceDispatchGetCall(
            accountId,
            userActionSetId,
            type,
            name,
            scenes,
            switchType,
            accessWay,
            fields,
            progressListener,
            progressRequestListener);
    return call;
  }

  /**
   * 数据源分发关系获取
   *
   * @param accountId (required)
   * @param userActionSetId (optional)
   * @param type (optional)
   * @param name (optional)
   * @param scenes (optional)
   * @param switchType (optional)
   * @param accessWay (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @return DataSourceDispatchGetResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public DataSourceDispatchGetResponse dataSourceDispatchGet(
      Long accountId,
      Long userActionSetId,
      String type,
      String name,
      List<String> scenes,
      String switchType,
      String accessWay,
      List<String> fields)
      throws ApiException {
    ApiResponse<DataSourceDispatchGetResponse> resp =
        dataSourceDispatchGetWithHttpInfo(
            accountId, userActionSetId, type, name, scenes, switchType, accessWay, fields);
    return resp.getData();
  }

  /**
   * 数据源分发关系获取
   *
   * @param accountId (required)
   * @param userActionSetId (optional)
   * @param type (optional)
   * @param name (optional)
   * @param scenes (optional)
   * @param switchType (optional)
   * @param accessWay (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @return ApiResponse&lt;DataSourceDispatchGetResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public ApiResponse<DataSourceDispatchGetResponse> dataSourceDispatchGetWithHttpInfo(
      Long accountId,
      Long userActionSetId,
      String type,
      String name,
      List<String> scenes,
      String switchType,
      String accessWay,
      List<String> fields)
      throws ApiException {
    com.squareup.okhttp.Call call =
        dataSourceDispatchGetValidateBeforeCall(
            accountId,
            userActionSetId,
            type,
            name,
            scenes,
            switchType,
            accessWay,
            fields,
            null,
            null);
    Type localVarReturnType = new TypeToken<DataSourceDispatchGetResponse>() {}.getType();
    return apiClient.execute(call, localVarReturnType);
  }

  /**
   * 数据源分发关系获取 (asynchronously)
   *
   * @param accountId (required)
   * @param userActionSetId (optional)
   * @param type (optional)
   * @param name (optional)
   * @param scenes (optional)
   * @param switchType (optional)
   * @param accessWay (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @param callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   */
  public com.squareup.okhttp.Call dataSourceDispatchGetAsync(
      Long accountId,
      Long userActionSetId,
      String type,
      String name,
      List<String> scenes,
      String switchType,
      String accessWay,
      List<String> fields,
      final ApiCallback<DataSourceDispatchGetResponse> callback)
      throws ApiException {

    ProgressResponseBody.ProgressListener progressListener = null;
    ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

    if (callback != null) {
      progressListener =
          new ProgressResponseBody.ProgressListener() {
            @Override
            public void update(long bytesRead, long contentLength, boolean done) {
              callback.onDownloadProgress(bytesRead, contentLength, done);
            }
          };

      progressRequestListener =
          new ProgressRequestBody.ProgressRequestListener() {
            @Override
            public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
              callback.onUploadProgress(bytesWritten, contentLength, done);
            }
          };
    }

    com.squareup.okhttp.Call call =
        dataSourceDispatchGetValidateBeforeCall(
            accountId,
            userActionSetId,
            type,
            name,
            scenes,
            switchType,
            accessWay,
            fields,
            progressListener,
            progressRequestListener);
    Type localVarReturnType = new TypeToken<DataSourceDispatchGetResponse>() {}.getType();
    apiClient.executeAsync(call, localVarReturnType, callback);
    return call;
  }
  /**
   * Build call for dataSourceDispatchUpdate
   *
   * @param data (required)
   * @param progressListener Progress listener
   * @param progressRequestListener Progress request listener
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   */
  public com.squareup.okhttp.Call dataSourceDispatchUpdateCall(
      DataSourceDispatchUpdateRequest data,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {
    Object localVarPostBody = data;

    // create path and map variables
    String localVarPath = "/data_source_dispatch/update";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

    Map<String, String> localVarHeaderParams = new HashMap<String, String>();

    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

    final String[] localVarContentTypes = {"application/json", "application/xml"};
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    if (progressListener != null) {
      apiClient
          .getHttpClient()
          .networkInterceptors()
          .add(
              new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(
                    com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                  com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                  return originalResponse
                      .newBuilder()
                      .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                      .build();
                }
              });
    }

    String[] localVarAuthNames = new String[] {"accessToken", "nonce", "timestamp"};
    return apiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarFormParams,
        localVarAuthNames,
        progressRequestListener);
  }

  @SuppressWarnings("rawtypes")
  private com.squareup.okhttp.Call dataSourceDispatchUpdateValidateBeforeCall(
      DataSourceDispatchUpdateRequest data,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {

    // verify the required parameter 'data' is set
    if (data == null) {
      throw new ApiException(
          "Missing the required parameter 'data' when calling dataSourceDispatchUpdate(Async)");
    }

    com.squareup.okhttp.Call call =
        dataSourceDispatchUpdateCall(data, progressListener, progressRequestListener);
    return call;
  }

  /**
   * 数据源分发关系更新
   *
   * @param data (required)
   * @return DataSourceDispatchUpdateResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public DataSourceDispatchUpdateResponse dataSourceDispatchUpdate(
      DataSourceDispatchUpdateRequest data) throws ApiException {
    ApiResponse<DataSourceDispatchUpdateResponse> resp = dataSourceDispatchUpdateWithHttpInfo(data);
    return resp.getData();
  }

  /**
   * 数据源分发关系更新
   *
   * @param data (required)
   * @return ApiResponse&lt;DataSourceDispatchUpdateResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public ApiResponse<DataSourceDispatchUpdateResponse> dataSourceDispatchUpdateWithHttpInfo(
      DataSourceDispatchUpdateRequest data) throws ApiException {
    com.squareup.okhttp.Call call = dataSourceDispatchUpdateValidateBeforeCall(data, null, null);
    Type localVarReturnType = new TypeToken<DataSourceDispatchUpdateResponse>() {}.getType();
    return apiClient.execute(call, localVarReturnType);
  }

  /**
   * 数据源分发关系更新 (asynchronously)
   *
   * @param data (required)
   * @param callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   */
  public com.squareup.okhttp.Call dataSourceDispatchUpdateAsync(
      DataSourceDispatchUpdateRequest data,
      final ApiCallback<DataSourceDispatchUpdateResponse> callback)
      throws ApiException {

    ProgressResponseBody.ProgressListener progressListener = null;
    ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

    if (callback != null) {
      progressListener =
          new ProgressResponseBody.ProgressListener() {
            @Override
            public void update(long bytesRead, long contentLength, boolean done) {
              callback.onDownloadProgress(bytesRead, contentLength, done);
            }
          };

      progressRequestListener =
          new ProgressRequestBody.ProgressRequestListener() {
            @Override
            public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
              callback.onUploadProgress(bytesWritten, contentLength, done);
            }
          };
    }

    com.squareup.okhttp.Call call =
        dataSourceDispatchUpdateValidateBeforeCall(data, progressListener, progressRequestListener);
    Type localVarReturnType = new TypeToken<DataSourceDispatchUpdateResponse>() {}.getType();
    apiClient.executeAsync(call, localVarReturnType, callback);
    return call;
  }
}
