/*
 * Marketing API
 * Marketing API
 *
 * OpenAPI spec version: 1.3
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.DateRange;
import com.tencent.ads.model.UserActionSetReportsGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserActionSetReportsApi {
  private ApiClient apiClient;

  public UserActionSetReportsApi() {
    this(Configuration.getDefaultApiClient());
  }

  public UserActionSetReportsApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Build call for userActionSetReportsGet
   *
   * @param accountId (required)
   * @param userActionSetId (required)
   * @param dateRange (required)
   * @param timeGranularity (required)
   * @param aggregation (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @param progressListener Progress listener
   * @param progressRequestListener Progress request listener
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   */
  public com.squareup.okhttp.Call userActionSetReportsGetCall(
      Long accountId,
      Long userActionSetId,
      DateRange dateRange,
      String timeGranularity,
      String aggregation,
      List<String> fields,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath = "/user_action_set_reports/get";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    if (accountId != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("account_id", accountId));
    if (userActionSetId != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("user_action_set_id", userActionSetId));
    if (dateRange != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("date_range", dateRange));
    if (timeGranularity != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("time_granularity", timeGranularity));
    if (aggregation != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("aggregation", aggregation));
    if (fields != null)
      localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "fields", fields));

    Map<String, String> localVarHeaderParams = new HashMap<String, String>();

    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

    final String[] localVarContentTypes = {"text/plain"};
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    if (progressListener != null) {
      apiClient
          .getHttpClient()
          .networkInterceptors()
          .add(
              new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(
                    com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                  com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                  return originalResponse
                      .newBuilder()
                      .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                      .build();
                }
              });
    }

    String[] localVarAuthNames = new String[] {"accessToken", "nonce", "timestamp"};
    return apiClient.buildCall(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarFormParams,
        localVarAuthNames,
        progressRequestListener);
  }

  @SuppressWarnings("rawtypes")
  private com.squareup.okhttp.Call userActionSetReportsGetValidateBeforeCall(
      Long accountId,
      Long userActionSetId,
      DateRange dateRange,
      String timeGranularity,
      String aggregation,
      List<String> fields,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          "Missing the required parameter 'accountId' when calling userActionSetReportsGet(Async)");
    }

    // verify the required parameter 'userActionSetId' is set
    if (userActionSetId == null) {
      throw new ApiException(
          "Missing the required parameter 'userActionSetId' when calling userActionSetReportsGet(Async)");
    }

    // verify the required parameter 'dateRange' is set
    if (dateRange == null) {
      throw new ApiException(
          "Missing the required parameter 'dateRange' when calling userActionSetReportsGet(Async)");
    }

    // verify the required parameter 'timeGranularity' is set
    if (timeGranularity == null) {
      throw new ApiException(
          "Missing the required parameter 'timeGranularity' when calling userActionSetReportsGet(Async)");
    }

    com.squareup.okhttp.Call call =
        userActionSetReportsGetCall(
            accountId,
            userActionSetId,
            dateRange,
            timeGranularity,
            aggregation,
            fields,
            progressListener,
            progressRequestListener);
    return call;
  }

  /**
   * 获取用户行为数据源报表
   *
   * @param accountId (required)
   * @param userActionSetId (required)
   * @param dateRange (required)
   * @param timeGranularity (required)
   * @param aggregation (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @return UserActionSetReportsGetResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public UserActionSetReportsGetResponse userActionSetReportsGet(
      Long accountId,
      Long userActionSetId,
      DateRange dateRange,
      String timeGranularity,
      String aggregation,
      List<String> fields)
      throws ApiException {
    ApiResponse<UserActionSetReportsGetResponse> resp =
        userActionSetReportsGetWithHttpInfo(
            accountId, userActionSetId, dateRange, timeGranularity, aggregation, fields);
    return resp.getData();
  }

  /**
   * 获取用户行为数据源报表
   *
   * @param accountId (required)
   * @param userActionSetId (required)
   * @param dateRange (required)
   * @param timeGranularity (required)
   * @param aggregation (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @return ApiResponse&lt;UserActionSetReportsGetResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public ApiResponse<UserActionSetReportsGetResponse> userActionSetReportsGetWithHttpInfo(
      Long accountId,
      Long userActionSetId,
      DateRange dateRange,
      String timeGranularity,
      String aggregation,
      List<String> fields)
      throws ApiException {
    com.squareup.okhttp.Call call =
        userActionSetReportsGetValidateBeforeCall(
            accountId,
            userActionSetId,
            dateRange,
            timeGranularity,
            aggregation,
            fields,
            null,
            null);
    Type localVarReturnType = new TypeToken<UserActionSetReportsGetResponse>() {}.getType();
    return apiClient.execute(call, localVarReturnType);
  }

  /**
   * 获取用户行为数据源报表 (asynchronously)
   *
   * @param accountId (required)
   * @param userActionSetId (required)
   * @param dateRange (required)
   * @param timeGranularity (required)
   * @param aggregation (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @param callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   */
  public com.squareup.okhttp.Call userActionSetReportsGetAsync(
      Long accountId,
      Long userActionSetId,
      DateRange dateRange,
      String timeGranularity,
      String aggregation,
      List<String> fields,
      final ApiCallback<UserActionSetReportsGetResponse> callback)
      throws ApiException {

    ProgressResponseBody.ProgressListener progressListener = null;
    ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

    if (callback != null) {
      progressListener =
          new ProgressResponseBody.ProgressListener() {
            @Override
            public void update(long bytesRead, long contentLength, boolean done) {
              callback.onDownloadProgress(bytesRead, contentLength, done);
            }
          };

      progressRequestListener =
          new ProgressRequestBody.ProgressRequestListener() {
            @Override
            public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
              callback.onUploadProgress(bytesWritten, contentLength, done);
            }
          };
    }

    com.squareup.okhttp.Call call =
        userActionSetReportsGetValidateBeforeCall(
            accountId,
            userActionSetId,
            dateRange,
            timeGranularity,
            aggregation,
            fields,
            progressListener,
            progressRequestListener);
    Type localVarReturnType = new TypeToken<UserActionSetReportsGetResponse>() {}.getType();
    apiClient.executeAsync(call, localVarReturnType, callback);
    return call;
  }
}
