package com.tencent.ads.examples.BasicOperations.AudiencesManagement;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.TencentAds;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.*;
import java.util.Arrays;
import java.util.List;

public class GetUserPropertySets {
  /** YOUR ACCESS TOKEN */
  public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";

  /** TencentAds */
  public TencentAds tencentAds;

  public Long accountId = null;

  public Long userPropertySetId = null;

  public List<String> fields =
      Arrays.asList("user_property_set_id", "name", "description", "created_time");

  public void init() {
    this.tencentAds = TencentAds.getInstance();
    this.tencentAds.init(
        new ApiContextConfig().accessToken(ACCESS_TOKEN).isDebug(true)); // debug==true 会打印请求详细信息
    this.tencentAds.useSandbox(); // 默认使用沙箱环境，如果要请求线上，这里需要设为线上环境
    this.buildParams();
  }

  public void buildParams() {}

  public UserPropertySetsGetResponseData getUserPropertySets() throws Exception {
    UserPropertySetsGetResponseData response =
        tencentAds.userPropertySets().userPropertySetsGet(accountId, userPropertySetId, fields);
    return response;
  }

  public static void main(String[] args) {
    try {
      GetUserPropertySets getUserPropertySets = new GetUserPropertySets();
      getUserPropertySets.init();
      UserPropertySetsGetResponseData response = getUserPropertySets.getUserPropertySets();
    } catch (TencentAdsResponseException e) {
      e.printStackTrace();
    } catch (TencentAdsSDKException e) {
      e.printStackTrace();
    } catch (Exception e) {
      e.printStackTrace();
    }
  }
}
