/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.CreativeSampleProductsGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CreativeSampleProductsApi {
    private ApiClient apiClient;

    public CreativeSampleProductsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CreativeSampleProductsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call creativeSampleProductsGetCall(Long accountId, Long productCatalogId, List<String> productOuterIds, Long productSeriesId, Long templateId, String templateType, String imageId, String videoId, List<String> productFields, Long limit, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/creative_sample_products/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (productCatalogId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("product_catalog_id", productCatalogId));
        }
        if (productOuterIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "product_outer_ids", productOuterIds));
        }
        if (productSeriesId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("product_series_id", productSeriesId));
        }
        if (templateId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("template_id", templateId));
        }
        if (templateType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("template_type", templateType));
        }
        if (imageId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("image_id", imageId));
        }
        if (videoId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("video_id", videoId));
        }
        if (productFields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "product_fields", productFields));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call creativeSampleProductsGetValidateBeforeCall(Long accountId, Long productCatalogId, List<String> productOuterIds, Long productSeriesId, Long templateId, String templateType, String imageId, String videoId, List<String> productFields, Long limit, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling creativeSampleProductsGet(Async)");
        }
        if (productCatalogId == null) {
            throw new ApiException("Missing the required parameter 'productCatalogId' when calling creativeSampleProductsGet(Async)");
        }
        Call call = this.creativeSampleProductsGetCall(accountId, productCatalogId, productOuterIds, productSeriesId, templateId, templateType, imageId, videoId, productFields, limit, fields, progressListener, progressRequestListener);
        return call;
    }

    public CreativeSampleProductsGetResponse creativeSampleProductsGet(Long accountId, Long productCatalogId, List<String> productOuterIds, Long productSeriesId, Long templateId, String templateType, String imageId, String videoId, List<String> productFields, Long limit, List<String> fields) throws ApiException {
        ApiResponse<CreativeSampleProductsGetResponse> resp = this.creativeSampleProductsGetWithHttpInfo(accountId, productCatalogId, productOuterIds, productSeriesId, templateId, templateType, imageId, videoId, productFields, limit, fields);
        return resp.getData();
    }

    public ApiResponse<CreativeSampleProductsGetResponse> creativeSampleProductsGetWithHttpInfo(Long accountId, Long productCatalogId, List<String> productOuterIds, Long productSeriesId, Long templateId, String templateType, String imageId, String videoId, List<String> productFields, Long limit, List<String> fields) throws ApiException {
        Call call = this.creativeSampleProductsGetValidateBeforeCall(accountId, productCatalogId, productOuterIds, productSeriesId, templateId, templateType, imageId, videoId, productFields, limit, fields, null, null);
        Type localVarReturnType = new TypeToken<CreativeSampleProductsGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call creativeSampleProductsGetAsync(Long accountId, Long productCatalogId, List<String> productOuterIds, Long productSeriesId, Long templateId, String templateType, String imageId, String videoId, List<String> productFields, Long limit, List<String> fields, final ApiCallback<CreativeSampleProductsGetResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.creativeSampleProductsGetValidateBeforeCall(accountId, productCatalogId, productOuterIds, productSeriesId, templateId, templateType, imageId, videoId, productFields, limit, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreativeSampleProductsGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

