/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.DynamicAdVideoTemplatesGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DynamicAdVideoTemplatesApi {
    private ApiClient apiClient;

    public DynamicAdVideoTemplatesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DynamicAdVideoTemplatesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call dynamicAdVideoTemplatesGetCall(Long accountId, Long productCatalogId, Long adcreativeTemplateId, String productMode, Boolean supportChannel, Long page, Long pageSize, List<Long> templateIdList, String templateName, String dynamicAdTemplateOwnershipType, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/dynamic_ad_video_templates/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (productCatalogId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("product_catalog_id", productCatalogId));
        }
        if (adcreativeTemplateId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("adcreative_template_id", adcreativeTemplateId));
        }
        if (productMode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("product_mode", productMode));
        }
        if (supportChannel != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("support_channel", supportChannel));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (templateIdList != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "template_id_list", templateIdList));
        }
        if (templateName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("template_name", templateName));
        }
        if (dynamicAdTemplateOwnershipType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dynamic_ad_template_ownership_type", dynamicAdTemplateOwnershipType));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call dynamicAdVideoTemplatesGetValidateBeforeCall(Long accountId, Long productCatalogId, Long adcreativeTemplateId, String productMode, Boolean supportChannel, Long page, Long pageSize, List<Long> templateIdList, String templateName, String dynamicAdTemplateOwnershipType, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling dynamicAdVideoTemplatesGet(Async)");
        }
        if (productCatalogId == null) {
            throw new ApiException("Missing the required parameter 'productCatalogId' when calling dynamicAdVideoTemplatesGet(Async)");
        }
        if (adcreativeTemplateId == null) {
            throw new ApiException("Missing the required parameter 'adcreativeTemplateId' when calling dynamicAdVideoTemplatesGet(Async)");
        }
        if (productMode == null) {
            throw new ApiException("Missing the required parameter 'productMode' when calling dynamicAdVideoTemplatesGet(Async)");
        }
        Call call = this.dynamicAdVideoTemplatesGetCall(accountId, productCatalogId, adcreativeTemplateId, productMode, supportChannel, page, pageSize, templateIdList, templateName, dynamicAdTemplateOwnershipType, fields, progressListener, progressRequestListener);
        return call;
    }

    public DynamicAdVideoTemplatesGetResponse dynamicAdVideoTemplatesGet(Long accountId, Long productCatalogId, Long adcreativeTemplateId, String productMode, Boolean supportChannel, Long page, Long pageSize, List<Long> templateIdList, String templateName, String dynamicAdTemplateOwnershipType, List<String> fields) throws ApiException {
        ApiResponse<DynamicAdVideoTemplatesGetResponse> resp = this.dynamicAdVideoTemplatesGetWithHttpInfo(accountId, productCatalogId, adcreativeTemplateId, productMode, supportChannel, page, pageSize, templateIdList, templateName, dynamicAdTemplateOwnershipType, fields);
        return resp.getData();
    }

    public ApiResponse<DynamicAdVideoTemplatesGetResponse> dynamicAdVideoTemplatesGetWithHttpInfo(Long accountId, Long productCatalogId, Long adcreativeTemplateId, String productMode, Boolean supportChannel, Long page, Long pageSize, List<Long> templateIdList, String templateName, String dynamicAdTemplateOwnershipType, List<String> fields) throws ApiException {
        Call call = this.dynamicAdVideoTemplatesGetValidateBeforeCall(accountId, productCatalogId, adcreativeTemplateId, productMode, supportChannel, page, pageSize, templateIdList, templateName, dynamicAdTemplateOwnershipType, fields, null, null);
        Type localVarReturnType = new TypeToken<DynamicAdVideoTemplatesGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call dynamicAdVideoTemplatesGetAsync(Long accountId, Long productCatalogId, Long adcreativeTemplateId, String productMode, Boolean supportChannel, Long page, Long pageSize, List<Long> templateIdList, String templateName, String dynamicAdTemplateOwnershipType, List<String> fields, final ApiCallback<DynamicAdVideoTemplatesGetResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.dynamicAdVideoTemplatesGetValidateBeforeCall(accountId, productCatalogId, adcreativeTemplateId, productMode, supportChannel, page, pageSize, templateIdList, templateName, dynamicAdTemplateOwnershipType, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DynamicAdVideoTemplatesGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

