/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.GameFeatureAddRequest;
import com.tencent.ads.model.GameFeatureAddResponse;
import com.tencent.ads.model.GameFeatureGetResponse;
import com.tencent.ads.model.GameFeatureUpdateRequest;
import com.tencent.ads.model.GameFeatureUpdateResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GameFeatureApi {
    private ApiClient apiClient;

    public GameFeatureApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GameFeatureApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call gameFeatureAddCall(GameFeatureAddRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        GameFeatureAddRequest localVarPostBody = data;
        String localVarPath = "/game_feature/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call gameFeatureAddValidateBeforeCall(GameFeatureAddRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling gameFeatureAdd(Async)");
        }
        Call call = this.gameFeatureAddCall(data, progressListener, progressRequestListener);
        return call;
    }

    public GameFeatureAddResponse gameFeatureAdd(GameFeatureAddRequest data) throws ApiException {
        ApiResponse<GameFeatureAddResponse> resp = this.gameFeatureAddWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<GameFeatureAddResponse> gameFeatureAddWithHttpInfo(GameFeatureAddRequest data) throws ApiException {
        Call call = this.gameFeatureAddValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<GameFeatureAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call gameFeatureAddAsync(GameFeatureAddRequest data, final ApiCallback<GameFeatureAddResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.gameFeatureAddValidateBeforeCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GameFeatureAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call gameFeatureGetCall(Long accountId, String promotedObjectType, String promotedObjectId, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/game_feature/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (promotedObjectType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("promoted_object_type", promotedObjectType));
        }
        if (promotedObjectId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("promoted_object_id", promotedObjectId));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call gameFeatureGetValidateBeforeCall(Long accountId, String promotedObjectType, String promotedObjectId, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling gameFeatureGet(Async)");
        }
        if (promotedObjectType == null) {
            throw new ApiException("Missing the required parameter 'promotedObjectType' when calling gameFeatureGet(Async)");
        }
        if (promotedObjectId == null) {
            throw new ApiException("Missing the required parameter 'promotedObjectId' when calling gameFeatureGet(Async)");
        }
        Call call = this.gameFeatureGetCall(accountId, promotedObjectType, promotedObjectId, fields, progressListener, progressRequestListener);
        return call;
    }

    public GameFeatureGetResponse gameFeatureGet(Long accountId, String promotedObjectType, String promotedObjectId, List<String> fields) throws ApiException {
        ApiResponse<GameFeatureGetResponse> resp = this.gameFeatureGetWithHttpInfo(accountId, promotedObjectType, promotedObjectId, fields);
        return resp.getData();
    }

    public ApiResponse<GameFeatureGetResponse> gameFeatureGetWithHttpInfo(Long accountId, String promotedObjectType, String promotedObjectId, List<String> fields) throws ApiException {
        Call call = this.gameFeatureGetValidateBeforeCall(accountId, promotedObjectType, promotedObjectId, fields, null, null);
        Type localVarReturnType = new TypeToken<GameFeatureGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call gameFeatureGetAsync(Long accountId, String promotedObjectType, String promotedObjectId, List<String> fields, final ApiCallback<GameFeatureGetResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.gameFeatureGetValidateBeforeCall(accountId, promotedObjectType, promotedObjectId, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GameFeatureGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call gameFeatureUpdateCall(GameFeatureUpdateRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        GameFeatureUpdateRequest localVarPostBody = data;
        String localVarPath = "/game_feature/update";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call gameFeatureUpdateValidateBeforeCall(GameFeatureUpdateRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling gameFeatureUpdate(Async)");
        }
        Call call = this.gameFeatureUpdateCall(data, progressListener, progressRequestListener);
        return call;
    }

    public GameFeatureUpdateResponse gameFeatureUpdate(GameFeatureUpdateRequest data) throws ApiException {
        ApiResponse<GameFeatureUpdateResponse> resp = this.gameFeatureUpdateWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<GameFeatureUpdateResponse> gameFeatureUpdateWithHttpInfo(GameFeatureUpdateRequest data) throws ApiException {
        Call call = this.gameFeatureUpdateValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<GameFeatureUpdateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call gameFeatureUpdateAsync(GameFeatureUpdateRequest data, final ApiCallback<GameFeatureUpdateResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.gameFeatureUpdateValidateBeforeCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GameFeatureUpdateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

