/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.PromotedObjectAuthorizationAddRequest;
import com.tencent.ads.model.PromotedObjectAuthorizationAddResponse;
import com.tencent.ads.model.PromotedObjectAuthorizationGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PromotedObjectAuthorizationApi {
    private ApiClient apiClient;

    public PromotedObjectAuthorizationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PromotedObjectAuthorizationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call promotedObjectAuthorizationAddCall(PromotedObjectAuthorizationAddRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PromotedObjectAuthorizationAddRequest localVarPostBody = data;
        String localVarPath = "/promoted_object_authorization/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call promotedObjectAuthorizationAddValidateBeforeCall(PromotedObjectAuthorizationAddRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling promotedObjectAuthorizationAdd(Async)");
        }
        Call call = this.promotedObjectAuthorizationAddCall(data, progressListener, progressRequestListener);
        return call;
    }

    public PromotedObjectAuthorizationAddResponse promotedObjectAuthorizationAdd(PromotedObjectAuthorizationAddRequest data) throws ApiException {
        ApiResponse<PromotedObjectAuthorizationAddResponse> resp = this.promotedObjectAuthorizationAddWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<PromotedObjectAuthorizationAddResponse> promotedObjectAuthorizationAddWithHttpInfo(PromotedObjectAuthorizationAddRequest data) throws ApiException {
        Call call = this.promotedObjectAuthorizationAddValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<PromotedObjectAuthorizationAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call promotedObjectAuthorizationAddAsync(PromotedObjectAuthorizationAddRequest data, final ApiCallback<PromotedObjectAuthorizationAddResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.promotedObjectAuthorizationAddValidateBeforeCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PromotedObjectAuthorizationAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call promotedObjectAuthorizationGetCall(Long accountId, String promotedObjectType, String promotedObjectName, Long page, Long pageSize, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/promoted_object_authorization/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (promotedObjectType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("promoted_object_type", promotedObjectType));
        }
        if (promotedObjectName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("promoted_object_name", promotedObjectName));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call promotedObjectAuthorizationGetValidateBeforeCall(Long accountId, String promotedObjectType, String promotedObjectName, Long page, Long pageSize, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling promotedObjectAuthorizationGet(Async)");
        }
        if (promotedObjectType == null) {
            throw new ApiException("Missing the required parameter 'promotedObjectType' when calling promotedObjectAuthorizationGet(Async)");
        }
        Call call = this.promotedObjectAuthorizationGetCall(accountId, promotedObjectType, promotedObjectName, page, pageSize, fields, progressListener, progressRequestListener);
        return call;
    }

    public PromotedObjectAuthorizationGetResponse promotedObjectAuthorizationGet(Long accountId, String promotedObjectType, String promotedObjectName, Long page, Long pageSize, List<String> fields) throws ApiException {
        ApiResponse<PromotedObjectAuthorizationGetResponse> resp = this.promotedObjectAuthorizationGetWithHttpInfo(accountId, promotedObjectType, promotedObjectName, page, pageSize, fields);
        return resp.getData();
    }

    public ApiResponse<PromotedObjectAuthorizationGetResponse> promotedObjectAuthorizationGetWithHttpInfo(Long accountId, String promotedObjectType, String promotedObjectName, Long page, Long pageSize, List<String> fields) throws ApiException {
        Call call = this.promotedObjectAuthorizationGetValidateBeforeCall(accountId, promotedObjectType, promotedObjectName, page, pageSize, fields, null, null);
        Type localVarReturnType = new TypeToken<PromotedObjectAuthorizationGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call promotedObjectAuthorizationGetAsync(Long accountId, String promotedObjectType, String promotedObjectName, Long page, Long pageSize, List<String> fields, final ApiCallback<PromotedObjectAuthorizationGetResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.promotedObjectAuthorizationGetValidateBeforeCall(accountId, promotedObjectType, promotedObjectName, page, pageSize, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PromotedObjectAuthorizationGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

