/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.FilteringStruct;
import com.tencent.ads.model.OrderByStruct;
import com.tencent.ads.model.ReportDateRange;
import com.tencent.ads.model.TargetingTagReportsGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TargetingTagReportsApi {
    private ApiClient apiClient;

    public TargetingTagReportsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TargetingTagReportsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call targetingTagReportsGetCall(Long accountId, String type, String level, ReportDateRange dateRange, String posType, List<FilteringStruct> filtering, List<String> groupBy, List<OrderByStruct> orderBy, Long page, Long pageSize, String timeLine, Boolean weixinOfficialAccountsUpgradeEnabled, Boolean adqAccountsUpgradeEnabled, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/targeting_tag_reports/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        if (level != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("level", level));
        }
        if (dateRange != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("date_range", dateRange));
        }
        if (posType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pos_type", posType));
        }
        if (filtering != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "filtering", filtering));
        }
        if (groupBy != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "group_by", groupBy));
        }
        if (orderBy != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "order_by", orderBy));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (timeLine != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("time_line", timeLine));
        }
        if (weixinOfficialAccountsUpgradeEnabled != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("weixin_official_accounts_upgrade_enabled", weixinOfficialAccountsUpgradeEnabled));
        }
        if (adqAccountsUpgradeEnabled != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("adq_accounts_upgrade_enabled", adqAccountsUpgradeEnabled));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call targetingTagReportsGetValidateBeforeCall(Long accountId, String type, String level, ReportDateRange dateRange, String posType, List<FilteringStruct> filtering, List<String> groupBy, List<OrderByStruct> orderBy, Long page, Long pageSize, String timeLine, Boolean weixinOfficialAccountsUpgradeEnabled, Boolean adqAccountsUpgradeEnabled, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling targetingTagReportsGet(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling targetingTagReportsGet(Async)");
        }
        if (level == null) {
            throw new ApiException("Missing the required parameter 'level' when calling targetingTagReportsGet(Async)");
        }
        if (dateRange == null) {
            throw new ApiException("Missing the required parameter 'dateRange' when calling targetingTagReportsGet(Async)");
        }
        Call call = this.targetingTagReportsGetCall(accountId, type, level, dateRange, posType, filtering, groupBy, orderBy, page, pageSize, timeLine, weixinOfficialAccountsUpgradeEnabled, adqAccountsUpgradeEnabled, fields, progressListener, progressRequestListener);
        return call;
    }

    public TargetingTagReportsGetResponse targetingTagReportsGet(Long accountId, String type, String level, ReportDateRange dateRange, String posType, List<FilteringStruct> filtering, List<String> groupBy, List<OrderByStruct> orderBy, Long page, Long pageSize, String timeLine, Boolean weixinOfficialAccountsUpgradeEnabled, Boolean adqAccountsUpgradeEnabled, List<String> fields) throws ApiException {
        ApiResponse<TargetingTagReportsGetResponse> resp = this.targetingTagReportsGetWithHttpInfo(accountId, type, level, dateRange, posType, filtering, groupBy, orderBy, page, pageSize, timeLine, weixinOfficialAccountsUpgradeEnabled, adqAccountsUpgradeEnabled, fields);
        return resp.getData();
    }

    public ApiResponse<TargetingTagReportsGetResponse> targetingTagReportsGetWithHttpInfo(Long accountId, String type, String level, ReportDateRange dateRange, String posType, List<FilteringStruct> filtering, List<String> groupBy, List<OrderByStruct> orderBy, Long page, Long pageSize, String timeLine, Boolean weixinOfficialAccountsUpgradeEnabled, Boolean adqAccountsUpgradeEnabled, List<String> fields) throws ApiException {
        Call call = this.targetingTagReportsGetValidateBeforeCall(accountId, type, level, dateRange, posType, filtering, groupBy, orderBy, page, pageSize, timeLine, weixinOfficialAccountsUpgradeEnabled, adqAccountsUpgradeEnabled, fields, null, null);
        Type localVarReturnType = new TypeToken<TargetingTagReportsGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call targetingTagReportsGetAsync(Long accountId, String type, String level, ReportDateRange dateRange, String posType, List<FilteringStruct> filtering, List<String> groupBy, List<OrderByStruct> orderBy, Long page, Long pageSize, String timeLine, Boolean weixinOfficialAccountsUpgradeEnabled, Boolean adqAccountsUpgradeEnabled, List<String> fields, final ApiCallback<TargetingTagReportsGetResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.targetingTagReportsGetValidateBeforeCall(accountId, type, level, dateRange, posType, filtering, groupBy, orderBy, page, pageSize, timeLine, weixinOfficialAccountsUpgradeEnabled, adqAccountsUpgradeEnabled, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TargetingTagReportsGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

