/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.ManualAdjustment;
import com.tencent.ads.model.SmartAdjustment;
import com.tencent.ads.model.VideomakerAutoadjustmentsAddResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class VideomakerAutoadjustmentsApi {
    private ApiClient apiClient;

    public VideomakerAutoadjustmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VideomakerAutoadjustmentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call videomakerAutoadjustmentsAddCall(Long accountId, String adjustmentType, String videoId, File videoFile, String signature, SmartAdjustment smartAdjustment, ManualAdjustment manualAdjustment, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/videomaker_autoadjustments/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accountId != null) {
            localVarFormParams.put("account_id", accountId);
        }
        if (videoId != null) {
            localVarFormParams.put("video_id", videoId);
        }
        if (videoFile != null) {
            localVarFormParams.put("video_file", videoFile);
        }
        if (signature != null) {
            localVarFormParams.put("signature", signature);
        }
        if (adjustmentType != null) {
            localVarFormParams.put("adjustment_type", adjustmentType);
        }
        if (smartAdjustment != null) {
            localVarFormParams.put("smart_adjustment", smartAdjustment);
        }
        if (manualAdjustment != null) {
            localVarFormParams.put("manual_adjustment", manualAdjustment);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call videomakerAutoadjustmentsAddValidateBeforeCall(Long accountId, String adjustmentType, String videoId, File videoFile, String signature, SmartAdjustment smartAdjustment, ManualAdjustment manualAdjustment, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling videomakerAutoadjustmentsAdd(Async)");
        }
        if (adjustmentType == null) {
            throw new ApiException("Missing the required parameter 'adjustmentType' when calling videomakerAutoadjustmentsAdd(Async)");
        }
        Call call = this.videomakerAutoadjustmentsAddCall(accountId, adjustmentType, videoId, videoFile, signature, smartAdjustment, manualAdjustment, progressListener, progressRequestListener);
        return call;
    }

    public VideomakerAutoadjustmentsAddResponse videomakerAutoadjustmentsAdd(Long accountId, String adjustmentType, String videoId, File videoFile, String signature, SmartAdjustment smartAdjustment, ManualAdjustment manualAdjustment) throws ApiException {
        ApiResponse<VideomakerAutoadjustmentsAddResponse> resp = this.videomakerAutoadjustmentsAddWithHttpInfo(accountId, adjustmentType, videoId, videoFile, signature, smartAdjustment, manualAdjustment);
        return resp.getData();
    }

    public ApiResponse<VideomakerAutoadjustmentsAddResponse> videomakerAutoadjustmentsAddWithHttpInfo(Long accountId, String adjustmentType, String videoId, File videoFile, String signature, SmartAdjustment smartAdjustment, ManualAdjustment manualAdjustment) throws ApiException {
        Call call = this.videomakerAutoadjustmentsAddValidateBeforeCall(accountId, adjustmentType, videoId, videoFile, signature, smartAdjustment, manualAdjustment, null, null);
        Type localVarReturnType = new TypeToken<VideomakerAutoadjustmentsAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call videomakerAutoadjustmentsAddAsync(Long accountId, String adjustmentType, String videoId, File videoFile, String signature, SmartAdjustment smartAdjustment, ManualAdjustment manualAdjustment, final ApiCallback<VideomakerAutoadjustmentsAddResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.videomakerAutoadjustmentsAddValidateBeforeCall(accountId, adjustmentType, videoId, videoFile, signature, smartAdjustment, manualAdjustment, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<VideomakerAutoadjustmentsAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

