/*
 * Tencent is pleased to support the open source community by making Angel available.
 *
 * Copyright (C) 2017-2018 THL A29 Limited, a Tencent company. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 *
 * https://opensource.org/licenses/Apache-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.tencent.angel.graph.client.psf.sample.sampleedgefeats;

import com.tencent.angel.graph.client.psf.sample.SampleUtils;
import com.tencent.angel.graph.utils.GraphMatrixUtils;
import com.tencent.angel.ml.math2.vector.IntFloatVector;
import com.tencent.angel.ml.matrix.psf.get.base.GetFunc;
import com.tencent.angel.ml.matrix.psf.get.base.GetResult;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetParam;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetResult;
import com.tencent.angel.ps.storage.vector.ServerLongAnyRow;
import com.tencent.angel.psagent.matrix.transport.router.operator.ILongKeyPartOp;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import scala.Tuple2;

public class SampleEdgeFeat extends GetFunc {

  /**
   * Create a new DefaultGetFunc.
   *
   * @param param parameter of get udf
   */
  public SampleEdgeFeat(SampleEdgeFeatParam param) {
    super(param);
  }

  public SampleEdgeFeat() {
    this(null);
  }

  @Override
  public PartitionGetResult partitionGet(PartitionGetParam partParam) {
    PartSampleEdgeFeatParam sampleParam = (PartSampleEdgeFeatParam) partParam;
    ServerLongAnyRow row = GraphMatrixUtils.getPSLongKeyRow(psContext, partParam);

    ILongKeyPartOp split = (ILongKeyPartOp) sampleParam.getIndicesPart();
    long[] nodeIds = split.getKeys();

    Tuple2<Long2ObjectOpenHashMap<long[]>, Long2ObjectOpenHashMap<IntFloatVector[]>> nodeId2SampleNeighbors =
        SampleUtils
            .sampleEdgeFeat(row, sampleParam.getCount(), nodeIds, System.currentTimeMillis());

    return new PartSampleEdgeFeatResult(sampleParam.getPartKey().getPartitionId(),
        nodeId2SampleNeighbors._1, nodeId2SampleNeighbors._2);
  }

  @Override
  public GetResult merge(List<PartitionGetResult> partResults) {
    Long2ObjectOpenHashMap<long[]> nodeIdToSampleNeighbors =
        new Long2ObjectOpenHashMap<>(((SampleEdgeFeatParam) param).getNodeIds().length);
    Long2ObjectOpenHashMap<IntFloatVector[]> nodeIdToEdgeFeats =
        new Long2ObjectOpenHashMap<>(((SampleEdgeFeatParam) param).getNodeIds().length);

    for (PartitionGetResult partResult : partResults) {
      // Sample part result
      PartSampleEdgeFeatResult partSampleResult = (PartSampleEdgeFeatResult) partResult;

      // Neighbors
      Long2ObjectOpenHashMap<long[]> partNodeIdToSampleNeighbors = partSampleResult
          .getNodeIdToSampleNeighbors();
      if (partNodeIdToSampleNeighbors != null) {
        nodeIdToSampleNeighbors.putAll(partNodeIdToSampleNeighbors);
      }

      // EdgeFeatures
      Long2ObjectOpenHashMap<IntFloatVector[]> partNodeIdToEdgeFeats = partSampleResult
          .getNodeIdToSampleEdgeFeats();
      if (partNodeIdToSampleNeighbors != null) {
        nodeIdToEdgeFeats.putAll(partNodeIdToEdgeFeats);
      }
    }
    return new SampleEdgeFeatResult(nodeIdToSampleNeighbors, nodeIdToEdgeFeats);
  }
}
