/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.getNodeAttrs;

import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetResult;
import io.netty.buffer.ByteBuf;

public class PartGetNodeAttrsResult
extends PartitionGetResult {
    private int partId;
    private float[][] nodeIdToAttrs;

    public PartGetNodeAttrsResult(int partId, float[][] nodeIdToAttrs) {
        this.partId = partId;
        this.nodeIdToAttrs = nodeIdToAttrs;
    }

    public PartGetNodeAttrsResult() {
        this(-1, null);
    }

    public float[][] getNodeIdToAttrs() {
        return this.nodeIdToAttrs;
    }

    public void setNodeIdToAttrs(float[][] nodeIdToAttrs) {
        this.nodeIdToAttrs = nodeIdToAttrs;
    }

    public int getPartId() {
        return this.partId;
    }

    public void serialize(ByteBuf output) {
        output.writeInt(this.partId);
        output.writeInt(this.nodeIdToAttrs.length);
        for (int i = 0; i < this.nodeIdToAttrs.length; ++i) {
            if (this.nodeIdToAttrs[i] == null) {
                output.writeInt(0);
                continue;
            }
            output.writeInt(this.nodeIdToAttrs[i].length);
            for (float value : this.nodeIdToAttrs[i]) {
                output.writeFloat(value);
            }
        }
    }

    public void deserialize(ByteBuf input) {
        this.partId = input.readInt();
        int size = input.readInt();
        this.nodeIdToAttrs = new float[size][];
        for (int i = 0; i < size; ++i) {
            float[] attrs = new float[input.readInt()];
            for (int j = 0; j < attrs.length; ++j) {
                attrs[j] = input.readFloat();
            }
            this.nodeIdToAttrs[i] = attrs;
        }
    }

    public int bufferLen() {
        int len = 8;
        for (int i = 0; i < this.nodeIdToAttrs.length; ++i) {
            if (this.nodeIdToAttrs[i] == null) {
                len += 4;
                continue;
            }
            len += 4;
            len += 4 * this.nodeIdToAttrs[i].length;
        }
        return len;
    }
}

