/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.getnodefeats;

import com.tencent.angel.common.ByteBufSerdeUtils;
import com.tencent.angel.graph.data.NodeUtils;
import com.tencent.angel.ml.math2.vector.IntFloatVector;
import com.tencent.angel.ml.matrix.psf.get.base.PartitionGetResult;
import io.netty.buffer.ByteBuf;

public class PartGetNodeFeatsResult
extends PartitionGetResult {
    private int partId;
    private IntFloatVector[] feats;

    public PartGetNodeFeatsResult(int partId, IntFloatVector[] feats) {
        this.partId = partId;
        this.feats = feats;
    }

    public PartGetNodeFeatsResult() {
        this(-1, null);
    }

    public int getPartId() {
        return this.partId;
    }

    public IntFloatVector[] getFeats() {
        return this.feats;
    }

    public void serialize(ByteBuf output) {
        output.writeInt(this.partId);
        output.writeInt(this.feats.length);
        for (int i = 0; i < this.feats.length; ++i) {
            if (this.feats[i] == null) {
                output.writeBoolean(true);
                continue;
            }
            output.writeBoolean(false);
            NodeUtils.serialize(this.feats[i], output);
        }
    }

    public void deserialize(ByteBuf input) {
        this.partId = input.readInt();
        int len = input.readInt();
        this.feats = new IntFloatVector[len];
        for (int i = 0; i < len; ++i) {
            boolean isNull = input.readBoolean();
            if (isNull) continue;
            this.feats[i] = NodeUtils.deserialize(input);
        }
    }

    public int bufferLen() {
        int len = 8;
        for (int i = 0; i < this.feats.length; ++i) {
            if (this.feats[i] == null) {
                len += ByteBufSerdeUtils.serializedBooleanLen((boolean)true);
                continue;
            }
            len += ByteBufSerdeUtils.serializedBooleanLen((boolean)false);
            len += NodeUtils.dataLen(this.feats[i]);
        }
        return len;
    }
}

