/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.initNeighbor5;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.exception.AngelException;
import com.tencent.angel.graph.client.initNeighbor5.InitNeighborPartParam;
import com.tencent.angel.graph.utils.LongIndexComparator;
import com.tencent.angel.ml.matrix.psf.update.base.PartitionUpdateParam;
import com.tencent.angel.ml.matrix.psf.update.base.UpdateParam;
import com.tencent.angel.psagent.PSAgentContext;
import com.tencent.angel.psagent.matrix.oplog.cache.RowUpdateSplitUtils;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.ArrayList;
import java.util.List;

public class InitNeighborParam
extends UpdateParam {
    private long[] keys;
    private int[] indptr;
    private long[] neighbors;
    private int[] edgeTypes;
    private int[] dstTypes;
    private int start;
    private int end;

    public InitNeighborParam(int matrixId, long[] keys, int[] indptr, long[] neighbors) {
        this(matrixId, keys, indptr, neighbors, 0, keys.length);
    }

    public InitNeighborParam(int matrixId, long[] keys, int[] indptr, long[] neighbors, int start, int end) {
        this(matrixId, keys, indptr, neighbors, null, null, start, end);
    }

    public InitNeighborParam(int matrixId, long[] keys, int[] indptr, long[] neighbors, int[] edgeTypes, int[] dstTypes, int start, int end) {
        super(matrixId);
        this.keys = keys;
        this.indptr = indptr;
        this.neighbors = neighbors;
        this.edgeTypes = edgeTypes;
        this.dstTypes = dstTypes;
        this.start = start;
        this.end = end;
        assert (start >= 0 && start < end && end <= keys.length);
    }

    public List<PartitionUpdateParam> split() {
        LongIndexComparator comparator = new LongIndexComparator(this.keys);
        int size = this.end - this.start;
        int[] index = new int[size];
        for (int i = 0; i < size; ++i) {
            index[i] = i + this.start;
        }
        IntArrays.quickSort((int[])index, (IntComparator)comparator);
        ArrayList<PartitionUpdateParam> params = new ArrayList<PartitionUpdateParam>();
        List parts = PSAgentContext.get().getMatrixMetaManager().getPartitions(this.matrixId);
        if (!RowUpdateSplitUtils.isInRange((long[])this.keys, (int[])index, (List)parts)) {
            throw new AngelException("node id is not in range [" + ((PartitionKey)parts.get(0)).getStartCol() + ", " + ((PartitionKey)parts.get(parts.size() - 1)).getEndCol());
        }
        int nodeIndex = this.start;
        for (int partIndex = 0; nodeIndex < this.end || partIndex < parts.size(); ++partIndex) {
            int length = 0;
            long endOffset = ((PartitionKey)parts.get(partIndex)).getEndCol();
            while (nodeIndex < this.end && this.keys[index[nodeIndex - this.start]] < endOffset) {
                ++nodeIndex;
                ++length;
            }
            if (length <= 0) continue;
            params.add(new InitNeighborPartParam(this.matrixId, (PartitionKey)parts.get(partIndex), this.keys, index, this.indptr, this.neighbors, this.edgeTypes, this.dstTypes, nodeIndex - length - this.start, nodeIndex - this.start));
        }
        return params;
    }
}

