/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.initNeighbor5;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.common.ByteBufSerdeUtils;
import com.tencent.angel.ml.matrix.psf.update.base.PartitionUpdateParam;
import io.netty.buffer.ByteBuf;

public class InitNeighborPartParam
extends PartitionUpdateParam {
    private long[] keys;
    private int[] index;
    private int[] indptr;
    private long[] neighbors;
    private int[] edgeTypes;
    private int[] dstTypes;
    private int startIndex;
    private int endIndex;
    private long[][] neighborArrays;
    private int[][] edgeTypeArrays;
    private int[][] dstTypeArrays;

    public InitNeighborPartParam(int matrixId, PartitionKey pkey, long[] keys, int[] index, int[] indptr, long[] neighbors, int[] edgeTypes, int[] dstTypes, int startIndex, int endIndex) {
        super(matrixId, pkey);
        this.keys = keys;
        this.index = index;
        this.indptr = indptr;
        this.neighbors = neighbors;
        this.edgeTypes = edgeTypes;
        this.dstTypes = dstTypes;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public InitNeighborPartParam() {
        this(0, null, null, null, null, null, null, null, 0, 0);
    }

    public long[] getKeys() {
        return this.keys;
    }

    public long[][] getNeighborArrays() {
        return this.neighborArrays;
    }

    public int[][] getEdgeTypeArrays() {
        return this.edgeTypeArrays;
    }

    public int[][] getDstTypeArrays() {
        return this.dstTypeArrays;
    }

    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        if (this.edgeTypes != null) {
            buf.writeBoolean(true);
        } else {
            buf.writeBoolean(false);
        }
        if (this.dstTypes != null) {
            buf.writeBoolean(true);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(this.endIndex - this.startIndex);
        for (int i = this.startIndex; i < this.endIndex; ++i) {
            int j;
            long key = this.keys[this.index[i]];
            int len = this.indptr[this.index[i] + 1] - this.indptr[this.index[i]];
            buf.writeLong(key);
            buf.writeInt(len);
            for (j = this.indptr[this.index[i]]; j < this.indptr[this.index[i] + 1]; ++j) {
                buf.writeLong(this.neighbors[j]);
            }
            if (this.edgeTypes != null) {
                for (j = this.indptr[this.index[i]]; j < this.indptr[this.index[i] + 1]; ++j) {
                    buf.writeInt(this.edgeTypes[j]);
                }
            }
            if (this.dstTypes == null) continue;
            for (j = this.indptr[this.index[i]]; j < this.indptr[this.index[i] + 1]; ++j) {
                buf.writeInt(this.dstTypes[j]);
            }
        }
    }

    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        boolean hasEdgeType = buf.readBoolean();
        boolean hasDstType = buf.readBoolean();
        int size = buf.readInt();
        this.keys = new long[size];
        this.neighborArrays = new long[size][];
        if (hasEdgeType) {
            this.edgeTypeArrays = new int[size][];
        }
        if (hasDstType) {
            this.dstTypeArrays = new int[size][];
        }
        for (int i = 0; i < size; ++i) {
            int j;
            long node;
            this.keys[i] = node = buf.readLong();
            int len = buf.readInt();
            long[] neighbors = new long[len];
            for (int j2 = 0; j2 < len; ++j2) {
                neighbors[j2] = buf.readLong();
            }
            this.neighborArrays[i] = neighbors;
            if (hasEdgeType) {
                int[] types = new int[len];
                for (j = 0; j < len; ++j) {
                    types[j] = buf.readInt();
                }
                this.edgeTypeArrays[i] = types;
            }
            if (!hasDstType) continue;
            int[] types = new int[len];
            for (j = 0; j < len; ++j) {
                types[j] = buf.readInt();
            }
            this.dstTypeArrays[i] = types;
        }
    }

    public int bufferLen() {
        int len = super.bufferLen();
        len += 4 + ByteBufSerdeUtils.serializedBooleanLen((boolean)true) + ByteBufSerdeUtils.serializedBooleanLen((boolean)true);
        for (int i = this.startIndex; i < this.endIndex; ++i) {
            len += 12;
            len += 8 * (this.indptr[this.index[i] + 1] - this.indptr[this.index[i]]);
            if (this.edgeTypes != null) {
                len += 4 * (this.indptr[this.index[i] + 1] - this.indptr[this.index[i]]);
            }
            if (this.dstTypes == null) continue;
            len += 4 * (this.indptr[this.index[i] + 1] - this.indptr[this.index[i]]);
        }
        return len;
    }
}

