/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.initneighbor;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.ml.matrix.psf.update.base.PartitionUpdateParam;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public class PartInitNeighborParam
extends PartitionUpdateParam {
    private int[] nodeIds;
    private Int2ObjectOpenHashMap<int[]> nodeIdToNeighbors;
    private transient int startPos;
    private transient int endPos;
    private int[] neighbors;
    private int[] neighborNums;

    public PartInitNeighborParam(int matrixId, PartitionKey partKey, int[] nodeIds, Int2ObjectOpenHashMap<int[]> nodeIdToNeighbors, int startPos, int endPos) {
        super(matrixId, partKey, false);
        this.nodeIds = nodeIds;
        this.nodeIdToNeighbors = nodeIdToNeighbors;
        this.startPos = startPos;
        this.endPos = endPos;
    }

    public PartInitNeighborParam() {
        this(-1, null, null, null, 0, 0);
    }

    public int[] getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(int[] nodeIds) {
        this.nodeIds = nodeIds;
    }

    public int[] getNeighbors() {
        return this.neighbors;
    }

    public void setNeighbors(int[] neighbors) {
        this.neighbors = neighbors;
    }

    public int[] getNeighborNums() {
        return this.neighborNums;
    }

    public void setNeighborNums(int[] neighborNums) {
        this.neighborNums = neighborNums;
    }

    public void serialize(ByteBuf buf) {
        int i;
        super.serialize(buf);
        buf.writeInt(this.endPos - this.startPos);
        for (i = this.startPos; i < this.endPos; ++i) {
            buf.writeInt(this.nodeIds[i]);
            buf.writeInt(((int[])this.nodeIdToNeighbors.get(this.nodeIds[i])).length);
        }
        for (i = this.startPos; i < this.endPos; ++i) {
            int[] neighbors = (int[])this.nodeIdToNeighbors.get(this.nodeIds[i]);
            for (int j = 0; j < neighbors.length; ++j) {
                buf.writeInt(neighbors[j]);
            }
        }
    }

    public void deserialize(ByteBuf buf) {
        int i;
        super.deserialize(buf);
        int len = buf.readInt();
        this.nodeIds = new int[len];
        this.neighborNums = new int[len];
        int totalNum = 0;
        for (i = 0; i < len; ++i) {
            this.nodeIds[i] = buf.readInt();
            this.neighborNums[i] = buf.readInt();
            totalNum += this.neighborNums[i];
        }
        this.neighbors = new int[totalNum];
        for (i = 0; i < totalNum; ++i) {
            this.neighbors[i] = buf.readInt();
        }
    }

    public int bufferLen() {
        int len = super.bufferLen();
        len += 4;
        for (int i = this.startPos; i < this.endPos; ++i) {
            len += 8;
            len += ((int[])this.nodeIdToNeighbors.get(this.nodeIds[i])).length * 4;
        }
        return len;
    }
}

