/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.initneighbor2;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.exception.AngelException;
import com.tencent.angel.graph.client.initneighbor2.PartInitNeighborParam;
import com.tencent.angel.ml.matrix.psf.update.base.PartitionUpdateParam;
import com.tencent.angel.ml.matrix.psf.update.base.UpdateParam;
import com.tencent.angel.psagent.PSAgentContext;
import com.tencent.angel.psagent.matrix.oplog.cache.RowUpdateSplitUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InitNeighborParam
extends UpdateParam {
    private Long2ObjectMap<long[]> nodeIdToNeighborIndices;

    public InitNeighborParam(int matrixId, Long2ObjectMap<long[]> nodeIdToNeighborIndices) {
        super(matrixId);
        this.nodeIdToNeighborIndices = nodeIdToNeighborIndices;
    }

    public List<PartitionUpdateParam> split() {
        long[] nodeIds = this.nodeIdToNeighborIndices.keySet().toLongArray();
        Arrays.sort(nodeIds);
        ArrayList<PartitionUpdateParam> partParams = new ArrayList<PartitionUpdateParam>();
        List partitions = PSAgentContext.get().getMatrixMetaManager().getPartitions(this.matrixId);
        if (!RowUpdateSplitUtils.isInRange((long[])nodeIds, (List)partitions)) {
            throw new AngelException("node id is not in range [" + ((PartitionKey)partitions.get(0)).getStartCol() + ", " + ((PartitionKey)partitions.get(partitions.size() - 1)).getEndCol());
        }
        int nodeIndex = 0;
        for (int partIndex = 0; nodeIndex < nodeIds.length || partIndex < partitions.size(); ++partIndex) {
            int length = 0;
            long endOffset = ((PartitionKey)partitions.get(partIndex)).getEndCol();
            while (nodeIndex < nodeIds.length && nodeIds[nodeIndex] < endOffset) {
                ++nodeIndex;
                ++length;
            }
            if (length <= 0) continue;
            partParams.add(new PartInitNeighborParam(this.matrixId, (PartitionKey)partitions.get(partIndex), this.nodeIdToNeighborIndices, nodeIds, nodeIndex - length, nodeIndex));
        }
        return partParams;
    }
}

