/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.initneighbor2;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.ml.matrix.psf.update.base.PartitionUpdateParam;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;

public class PartInitNeighborParam
extends PartitionUpdateParam {
    private Long2ObjectMap<long[]> nodeIdToNeighborIndices;
    private long[] nodeIds;
    private transient int startIndex;
    private transient int endIndex;

    public PartInitNeighborParam(int matrixId, PartitionKey partKey, Long2ObjectMap<long[]> nodeIdToNeighborIndices, long[] nodeIds, int startIndex, int endIndex) {
        super(matrixId, partKey);
        this.nodeIdToNeighborIndices = nodeIdToNeighborIndices;
        this.nodeIds = nodeIds;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public PartInitNeighborParam() {
        this(0, null, null, null, 0, 0);
    }

    public Long2ObjectMap<long[]> getNodeIdToNeighborIndices() {
        return this.nodeIdToNeighborIndices;
    }

    private void clear() {
        this.nodeIdToNeighborIndices = null;
        this.nodeIds = null;
        this.startIndex = -1;
        this.endIndex = -1;
    }

    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        int writeIndex = buf.writerIndex();
        int writeNum = 0;
        buf.writeInt(0);
        for (int i = this.startIndex; i < this.endIndex; ++i) {
            long nodeId = this.nodeIds[i];
            long[] neighbors = (long[])this.nodeIdToNeighborIndices.get(nodeId);
            if (neighbors == null || neighbors.length == 0) continue;
            buf.writeLong(nodeId);
            buf.writeInt(neighbors.length);
            for (long neighbor : neighbors) {
                buf.writeLong(neighbor);
            }
            ++writeNum;
        }
        buf.setInt(writeIndex, writeNum);
    }

    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        int len = buf.readInt();
        this.nodeIdToNeighborIndices = new Long2ObjectArrayMap(len);
        for (int i = 0; i < len; ++i) {
            long nodeId = buf.readLong();
            int neighborNum = buf.readInt();
            long[] neighbor = new long[neighborNum];
            for (int j = 0; j < neighborNum; ++j) {
                neighbor[j] = buf.readLong();
            }
            this.nodeIdToNeighborIndices.put(nodeId, (Object)neighbor);
        }
    }

    public int bufferLen() {
        int len = super.bufferLen();
        len += 4;
        for (int i = this.startIndex; i < this.endIndex; ++i) {
            long nodeId = this.nodeIds[i];
            long[] neighbors = (long[])this.nodeIdToNeighborIndices.get(nodeId);
            if (neighbors == null || neighbors.length == 0) continue;
            len += 12;
            len += 8 * ((long[])this.nodeIdToNeighborIndices.get(this.nodeIds[i])).length;
        }
        return len;
    }
}

