/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.initnodefeats4;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.exception.AngelException;
import com.tencent.angel.graph.client.initnodefeats4.InitNodeFeatsPartParam;
import com.tencent.angel.graph.utils.LongIndexComparator;
import com.tencent.angel.ml.math2.vector.IntFloatVector;
import com.tencent.angel.ml.matrix.psf.update.base.PartitionUpdateParam;
import com.tencent.angel.ml.matrix.psf.update.base.UpdateParam;
import com.tencent.angel.psagent.PSAgentContext;
import com.tencent.angel.psagent.matrix.oplog.cache.RowUpdateSplitUtils;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.ArrayList;
import java.util.List;

public class InitNodeFeatsParam
extends UpdateParam {
    private final long[] keys;
    private final IntFloatVector[] feats;
    private final int startIndex;
    private final int endIndex;

    public InitNodeFeatsParam(int matrixId, long[] keys, IntFloatVector[] feats, int start, int end) {
        super(matrixId);
        this.keys = keys;
        this.feats = feats;
        this.startIndex = start;
        this.endIndex = end;
        assert (keys.length == feats.length);
    }

    public InitNodeFeatsParam(int matrixId, long[] keys, IntFloatVector[] feats) {
        super(matrixId);
        this.keys = keys;
        this.feats = feats;
        this.startIndex = 0;
        this.endIndex = keys.length;
    }

    public List<PartitionUpdateParam> split() {
        LongIndexComparator comparator = new LongIndexComparator(this.keys);
        int size = this.endIndex - this.startIndex;
        int[] index = new int[size];
        for (int i = 0; i < size; ++i) {
            index[i] = i + this.startIndex;
        }
        IntArrays.quickSort((int[])index, (IntComparator)comparator);
        ArrayList<PartitionUpdateParam> params = new ArrayList<PartitionUpdateParam>();
        List parts = PSAgentContext.get().getMatrixMetaManager().getPartitions(this.matrixId);
        if (!RowUpdateSplitUtils.isInRange((long[])this.keys, (int[])index, (List)parts)) {
            throw new AngelException("node id is not in range [" + ((PartitionKey)parts.get(0)).getStartCol() + ", " + ((PartitionKey)parts.get(parts.size() - 1)).getEndCol());
        }
        int nodeIndex = this.startIndex;
        for (int partIndex = 0; nodeIndex < this.endIndex || partIndex < parts.size(); ++partIndex) {
            int length = 0;
            long endOffset = ((PartitionKey)parts.get(partIndex)).getEndCol();
            while (nodeIndex < this.endIndex && this.keys[index[nodeIndex - this.startIndex]] < endOffset) {
                ++nodeIndex;
                ++length;
            }
            if (length <= 0) continue;
            params.add(new InitNodeFeatsPartParam(this.matrixId, (PartitionKey)parts.get(partIndex), this.keys, this.feats, index, nodeIndex - length - this.startIndex, nodeIndex - this.startIndex));
        }
        return params;
    }
}

