/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.angel.graph.client.initnodefeats4;

import com.tencent.angel.PartitionKey;
import com.tencent.angel.graph.data.NodeUtils;
import com.tencent.angel.ml.math2.vector.IntFloatVector;
import com.tencent.angel.ml.matrix.psf.update.base.PartitionUpdateParam;
import io.netty.buffer.ByteBuf;

public class InitNodeFeatsPartParam
extends PartitionUpdateParam {
    private long[] keys;
    private IntFloatVector[] feats;
    private int[] index;
    private int startIndex;
    private int endIndex;

    public InitNodeFeatsPartParam(int matrixId, PartitionKey partKey, long[] keys, IntFloatVector[] feats, int[] index, int startIndex, int endIndex) {
        super(matrixId, partKey);
        this.keys = keys;
        this.feats = feats;
        this.index = index;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public InitNodeFeatsPartParam() {
        this(-1, null, null, null, null, -1, -1);
    }

    public long[] getNodeIds() {
        return this.keys;
    }

    public IntFloatVector[] getFeats() {
        return this.feats;
    }

    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        int writeIndex = buf.writerIndex();
        int writeNum = 0;
        buf.writeInt(0);
        for (int i = this.startIndex; i < this.endIndex; ++i) {
            if (this.feats[this.index[i]] == null || this.feats[this.index[i]].getSize() == 0L) continue;
            buf.writeLong(this.keys[this.index[i]]);
            NodeUtils.serialize(this.feats[this.index[i]], buf);
            ++writeNum;
        }
        buf.setInt(writeIndex, writeNum);
    }

    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        int len = buf.readInt();
        this.keys = new long[len];
        this.feats = new IntFloatVector[len];
        for (int i = 0; i < len; ++i) {
            this.keys[i] = buf.readLong();
            this.feats[i] = NodeUtils.deserialize(buf);
        }
    }

    public int bufferLen() {
        int len = super.bufferLen();
        len += 4;
        for (int i = this.startIndex; i < this.endIndex; ++i) {
            if (this.feats[this.index[i]] == null || this.feats[this.index[i]].getSize() == 0L) continue;
            len += 8;
            len += NodeUtils.dataLen(this.feats[this.index[i]]);
        }
        return len;
    }
}

